"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTimelionVisualizationConfig = void 0;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const getTimelionVisualizationConfig = dependencies => ({
  name: 'timelion_vis',
  type: 'render',
  inputTypes: ['kibana_context', 'null'],
  help: _i18n.i18n.translate('timelion.function.help', {
    defaultMessage: 'Timelion visualization'
  }),
  args: {
    expression: {
      types: ['string'],
      aliases: ['_'],
      default: '".es(*)"',
      help: ''
    },
    interval: {
      types: ['string'],
      default: 'auto',
      help: ''
    },
    ariaLabel: {
      types: ['string'],
      help: _i18n.i18n.translate('timelion.function.args.ariaLabelHelpText', {
        defaultMessage: 'Specifies the aria label of the timelion'
      }),
      required: false
    }
  },
  async fn(input, args, {
    getSearchSessionId,
    getExecutionContext,
    variables,
    abortSignal: expressionAbortSignal,
    isSyncTooltipsEnabled,
    isSyncCursorEnabled
  }) {
    var _ref, _args$ariaLabel, _getExecutionContext, _isSyncTooltipsEnable, _isSyncTooltipsEnable2;
    const {
      getTimelionRequestHandler
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./async_services')));
    const visParams = {
      expression: args.expression,
      interval: args.interval,
      ariaLabel: (_ref = (_args$ariaLabel = args.ariaLabel) !== null && _args$ariaLabel !== void 0 ? _args$ariaLabel : variables === null || variables === void 0 ? void 0 : variables.embeddableTitle) !== null && _ref !== void 0 ? _ref : getExecutionContext === null || getExecutionContext === void 0 ? void 0 : (_getExecutionContext = getExecutionContext()) === null || _getExecutionContext === void 0 ? void 0 : _getExecutionContext.description
    };
    let visData;
    if (!expressionAbortSignal.aborted) {
      const timelionRequestHandler = getTimelionRequestHandler({
        ...dependencies,
        expressionAbortSignal
      });
      visData = await timelionRequestHandler({
        timeRange: (0, _lodash.get)(input, 'timeRange'),
        query: (0, _lodash.get)(input, 'query'),
        filters: (0, _lodash.get)(input, 'filters'),
        visParams,
        searchSessionId: getSearchSessionId(),
        executionContext: getExecutionContext()
      });
      visData.visType = _constants.TIMELION_VIS_NAME;
    }
    return {
      type: 'render',
      as: 'timelion_vis',
      value: {
        visParams,
        visType: _constants.TIMELION_VIS_NAME,
        visData,
        syncTooltips: (_isSyncTooltipsEnable = isSyncTooltipsEnabled === null || isSyncTooltipsEnabled === void 0 ? void 0 : isSyncTooltipsEnabled()) !== null && _isSyncTooltipsEnable !== void 0 ? _isSyncTooltipsEnable : false,
        syncCursor: (_isSyncTooltipsEnable2 = isSyncTooltipsEnabled === null || isSyncTooltipsEnabled === void 0 ? void 0 : isSyncTooltipsEnabled()) !== null && _isSyncTooltipsEnable2 !== void 0 ? _isSyncTooltipsEnable2 : true
      }
    };
  }
});
exports.getTimelionVisualizationConfig = getTimelionVisualizationConfig;