"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addPercentageColumn = addPercentageColumn;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _services = require("../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function insertColumn(arr, index, col) {
  const newArray = [...arr];
  newArray.splice(index + 1, 0, col);
  return newArray;
}

/**
 * Adds a brand new column with percentages of selected column to existing data table
 */
function addPercentageColumn(table, name) {
  const {
    columns,
    rows,
    formattedColumns
  } = table;
  const insertAtIndex = (0, _lodash.findIndex)(columns, {
    name
  });
  // column to show percentage for was removed
  if (insertAtIndex < 0) return table;
  const {
    id
  } = columns[insertAtIndex];
  const {
    sumTotal
  } = formattedColumns[id];
  const percentageColumnId = `${id}-percents`;
  const formatter = (0, _services.getFormatService)().deserialize({
    id: 'percent'
  });
  const percentageColumnName = _i18n.i18n.translate('visTypeTable.params.percentageTableColumnName', {
    defaultMessage: '{title} percentages',
    values: {
      title: name
    }
  });
  const newCols = insertColumn(columns, insertAtIndex, {
    name: percentageColumnName,
    id: percentageColumnId,
    meta: {
      type: 'number',
      params: {
        id: 'percent'
      }
    }
  });
  const newFormattedColumns = {
    ...formattedColumns,
    [percentageColumnId]: {
      title: percentageColumnName,
      formatter,
      filterable: false
    }
  };
  const newRows = rows.map(row => ({
    [percentageColumnId]: row[id] / sumTotal,
    ...row
  }));
  return {
    columns: newCols,
    rows: newRows,
    formattedColumns: newFormattedColumns
  };
}