"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableVisSplit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _uiTheme = require("@kbn/ui-theme");
var _table_vis_basic = require("./table_vis_basic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TableVisSplit = /*#__PURE__*/(0, _react.memo)(({
  fireEvent,
  tables,
  visConfig,
  uiStateProps,
  enforceMinWidth
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tables.map(({
    table,
    title
  }) => {
    // reserve minimum size per table
    const minTableWidth = table.columns.reduce((sum, column, index) => {
      var _uiStateProps$columns, _uiStateProps$columns2;
      return sum + ((_uiStateProps$columns = (_uiStateProps$columns2 = uiStateProps.columnsWidth.find(width => width.colIndex === index)) === null || _uiStateProps$columns2 === void 0 ? void 0 : _uiStateProps$columns2.width) !== null && _uiStateProps$columns !== void 0 ? _uiStateProps$columns : 25);
    }, 0);
    return /*#__PURE__*/_react.default.createElement("div", {
      key: title,
      className: "tbvChart__split",
      css: enforceMinWidth ? {
        minWidth: `calc(${minTableWidth}px + 2 * ${_uiTheme.euiThemeVars.euiSizeS})`
      } : {}
    }, /*#__PURE__*/_react.default.createElement(_table_vis_basic.TableVisBasic, {
      fireEvent: fireEvent,
      table: table,
      visConfig: visConfig,
      title: title,
      uiStateProps: uiStateProps
    }));
  }));
});
exports.TableVisSplit = TableVisSplit;