"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGaugeVisTypeDefinition = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/charts-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _public3 = require("@kbn/visualizations-plugin/public");
var _types = require("../types");
var _to_ast = require("../to_ast");
var _components = require("../editor/components");
var _split_tooltip = require("./split_tooltip");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const getGaugeVisTypeDefinition = props => ({
  name: 'gauge',
  title: _i18n.i18n.translate('visTypeGauge.gauge.gaugeTitle', {
    defaultMessage: 'Gauge'
  }),
  icon: 'visGauge',
  description: _i18n.i18n.translate('visTypeGauge.gauge.gaugeDescription', {
    defaultMessage: 'Show the status of a metric.'
  }),
  getSupportedTriggers: () => [_public3.VIS_EVENT_TO_TRIGGER.filter],
  fetchDatatable: true,
  toExpressionAst: _to_ast.toExpressionAst,
  visConfig: {
    defaults: {
      type: 'gauge',
      addTooltip: true,
      addLegend: true,
      isDisplayWarning: false,
      gauge: {
        alignment: _types.Alignment.Automatic,
        extendRange: true,
        percentageMode: false,
        gaugeType: _types.GaugeType.Arc,
        gaugeStyle: 'Full',
        backStyle: 'Full',
        orientation: 'vertical',
        colorSchema: _public.ColorSchemas.GreenToRed,
        gaugeColorMode: _public.ColorMode.Labels,
        colorsRange: [{
          from: 0,
          to: 50
        }, {
          from: 50,
          to: 75
        }, {
          from: 75,
          to: 100
        }],
        invertColors: false,
        labels: {
          show: true,
          color: 'black'
        },
        scale: {
          show: true,
          labels: false,
          color: 'rgba(105,112,125,0.2)'
        },
        type: 'meter',
        style: {
          bgWidth: 0.9,
          width: 0.9,
          mask: false,
          bgMask: false,
          maskBars: 50,
          bgFill: 'rgba(105,112,125,0.2)',
          bgColor: true,
          subText: '',
          fontSize: 60
        }
      }
    }
  },
  editorConfig: {
    enableDataViewChange: true,
    optionsTemplate: (0, _components.getGaugeOptions)(props),
    schemas: [{
      group: _public2.AggGroupNames.Metrics,
      name: 'metric',
      title: _i18n.i18n.translate('visTypeGauge.gauge.metricTitle', {
        defaultMessage: 'Metric'
      }),
      min: 1,
      ...(props.showElasticChartsOptions ? {
        max: 1
      } : {}),
      aggFilter: ['!std_dev', '!geo_centroid', '!percentiles', '!percentile_ranks', '!derivative', '!serial_diff', '!moving_avg', '!cumulative_sum', '!geo_bounds', '!filtered_metric', '!single_percentile', '!single_percentile_rank'],
      defaults: [{
        schema: 'metric',
        type: 'count'
      }]
    }, {
      group: _public2.AggGroupNames.Buckets,
      name: 'group',
      // TODO: Remove when split chart aggs are supported
      ...(props.showElasticChartsOptions && {
        disabled: true,
        tooltip: /*#__PURE__*/_react.default.createElement(_split_tooltip.SplitTooltip, null)
      }),
      title: _i18n.i18n.translate('visTypeGauge.gauge.groupTitle', {
        defaultMessage: 'Split group'
      }),
      min: 0,
      max: 1,
      aggFilter: ['!geotile_grid', '!filter', '!sampler', '!diversified_sampler', '!rare_terms', '!multi_terms', '!significant_text']
    }]
  },
  requiresSearch: true,
  navigateToLens: async (vis, timefilter) => {
    const {
      convertGaugeToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../convert_to_lens')));
    return vis ? convertGaugeToLens(vis, timefilter) : null;
  },
  getExpressionVariables: async (vis, timeFilter) => {
    const {
      convertGaugeToLens
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../convert_to_lens')));
    return {
      canNavigateToLens: Boolean(vis !== null && vis !== void 0 && vis.params ? await convertGaugeToLens(vis, timeFilter) : null)
    };
  }
});
exports.getGaugeVisTypeDefinition = getGaugeVisTypeDefinition;