"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorControls = DefaultEditorControls;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _state = require("./state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DefaultEditorControls({
  applyChanges,
  isDirty,
  isInvalid,
  isTouched,
  dispatch,
  vis
}) {
  const {
    enableAutoApply
  } = vis.type.editorConfig;
  const [autoApplyEnabled, setAutoApplyEnabled] = (0, _react.useState)(false);
  const toggleAutoApply = (0, _react.useCallback)(nextAutoApplyEnabled => setAutoApplyEnabled(nextAutoApplyEnabled), []);
  const onClickDiscard = (0, _react.useCallback)(() => dispatch((0, _state.discardChanges)(vis)), [dispatch, vis]);
  (0, _useDebounce.default)(() => {
    if (autoApplyEnabled && isDirty) {
      applyChanges();
    }
  }, 300, [isDirty, autoApplyEnabled, applyChanges]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "visEditorSidebar__controls"
  }, !autoApplyEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "visualizeEditorResetButton",
    disabled: !isDirty,
    iconType: "cross",
    onClick: onClickDiscard,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.sidebar.discardChangesButtonLabel",
    defaultMessage: "Discard"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isInvalid && isTouched ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('visDefaultEditor.sidebar.errorButtonTooltip', {
      defaultMessage: 'Errors in the highlighted fields need to be resolved.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    iconType: "warning",
    size: "s",
    disabled: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.sidebar.updateChartButtonLabel",
    defaultMessage: "Update"
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('visDefaultEditor.sidebar.updateInfoTooltip', {
      defaultMessage: 'CTRL + Enter is a shortcut for Update.'
    }),
    type: "keyboard",
    color: "subdued"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "visualizeEditorRenderButton",
    disabled: !isDirty,
    fill: true,
    iconType: "play",
    onClick: applyChanges,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.sidebar.updateChartButtonLabel",
    defaultMessage: "Update"
  })))))), enableAutoApply && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    title: autoApplyEnabled ? _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesOnLabel', {
      defaultMessage: 'Auto apply is on'
    }) : _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesOffLabel', {
      defaultMessage: 'Auto apply is off'
    }),
    content: _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesTooltip', {
      defaultMessage: 'Auto updates the visualization on every change.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: "visEditorSidebar__autoApplyButton",
    "data-test-subj": "visualizeEditorAutoButton",
    iconType: "refresh",
    color: autoApplyEnabled ? 'primary' : 'text',
    fill: true,
    onClick: () => toggleAutoApply(!autoApplyEnabled),
    size: "s",
    minWidth: 80,
    "aria-label": autoApplyEnabled ? _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesLabelOn', {
      defaultMessage: 'Auto apply is on'
    }) : _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesLabelOff', {
      defaultMessage: 'Auto apply is off'
    })
  }, autoApplyEnabled ? _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesOn', {
    defaultMessage: 'On'
  }) : _i18n.i18n.translate('visDefaultEditor.sidebar.autoApplyChangesOff', {
    defaultMessage: 'Off'
  }))));
}