"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RowsOrColumnsControl = RowsOrColumnsControl;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PARAMS = {
  NAME: 'row',
  ROWS: 'visEditorSplitBy__true',
  COLUMNS: 'visEditorSplitBy__false'
};
function RowsOrColumnsControl({
  editorStateParams,
  setStateParamValue
}) {
  if (editorStateParams.row === undefined) {
    setStateParamValue(PARAMS.NAME, true);
  }
  const idSelected = `visEditorSplitBy__${editorStateParams.row}`;
  const options = [{
    id: PARAMS.ROWS,
    label: _i18n.i18n.translate('visDefaultEditor.controls.rowsLabel', {
      defaultMessage: 'Rows'
    }),
    'data-test-subj': 'visEditorSplitBy-Rows'
  }, {
    id: PARAMS.COLUMNS,
    label: _i18n.i18n.translate('visDefaultEditor.controls.columnsLabel', {
      defaultMessage: 'Columns'
    }),
    'data-test-subj': 'visEditorSplitBy-Columns'
  }];
  const onChange = (0, _react.useCallback)(optionId => setStateParamValue(PARAMS.NAME, optionId === PARAMS.ROWS), [setStateParamValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    "data-test-subj": "visEditorSplitBy",
    legend: _i18n.i18n.translate('visDefaultEditor.controls.splitByLegend', {
      defaultMessage: 'Split chart by rows or columns.'
    }),
    options: options,
    isFullWidth: true,
    idSelected: idSelected,
    onChange: onChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}