"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FromToList = FromToList;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _input_list = require("./input_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EMPTY_STRING = '';
const defaultConfig = {
  defaultValue: {
    from: {
      value: '0.0.0.0',
      model: '0.0.0.0',
      isInvalid: false
    },
    to: {
      value: '255.255.255.255',
      model: '255.255.255.255',
      isInvalid: false
    }
  },
  validateClass: _public.search.aggs.IpAddress,
  getModelValue: (item = {}) => ({
    from: {
      value: item.from || EMPTY_STRING,
      model: item.from || EMPTY_STRING,
      isInvalid: false
    },
    to: {
      value: item.to || EMPTY_STRING,
      model: item.to || EMPTY_STRING,
      isInvalid: false
    }
  }),
  getRemoveBtnAriaLabel: item => _i18n.i18n.translate('visDefaultEditor.controls.ipRanges.removeRangeAriaLabel', {
    defaultMessage: 'Remove the range of {from} to {to}',
    values: {
      from: item.from.value || '*',
      to: item.to.value || '*'
    }
  }),
  onChangeFn: ({
    from,
    to
  }) => {
    const result = {};
    if (from.model) {
      result.from = from.model;
    }
    if (to.model) {
      result.to = to.model;
    }
    return result;
  },
  hasInvalidValuesFn: ({
    from,
    to
  }) => from.isInvalid || to.isInvalid,
  modelNames: ['from', 'to']
};
function FromToList({
  showValidation,
  onBlur,
  ...rest
}) {
  const renderInputRow = (0, _react.useCallback)((item, index, onChangeValue) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "aria-label": _i18n.i18n.translate('visDefaultEditor.controls.ipRanges.ipRangeFromAriaLabel', {
      defaultMessage: 'IP range from: {value}',
      values: {
        value: item.from.value || '*'
      }
    }),
    compressed: true,
    isInvalid: showValidation ? item.from.isInvalid : false,
    placeholder: "*",
    onChange: ev => {
      onChangeValue(index, ev.target.value, 'from');
    },
    value: item.from.value,
    onBlur: onBlur
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortRight",
    color: "subdued"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "aria-label": _i18n.i18n.translate('visDefaultEditor.controls.ipRanges.ipRangeToAriaLabel', {
      defaultMessage: 'IP range to: {value}',
      values: {
        value: item.to.value || '*'
      }
    }),
    compressed: true,
    isInvalid: showValidation ? item.to.isInvalid : false,
    placeholder: "*",
    onChange: ev => {
      onChangeValue(index, ev.target.value, 'to');
    },
    value: item.to.value,
    onBlur: onBlur
  }))), [onBlur, showValidation]);
  const fromToListConfig = {
    ...defaultConfig,
    renderInputRow
  };
  return /*#__PURE__*/_react.default.createElement(_input_list.InputList, (0, _extends2.default)({
    config: fromToListConfig
  }, rest));
}