"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorAggSelect = DefaultEditorAggSelect;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _agg_params_state = require("./agg_params_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DefaultEditorAggSelect({
  aggError,
  id,
  indexPattern,
  value,
  setValue,
  aggTypeOptions,
  showValidation,
  isSubAggregation,
  onChangeAggType
}) {
  const [isDirty, setIsDirty] = (0, _react.useState)(false);
  const {
    services
  } = (0, _public.useKibana)();
  const selectedOptions = value ? [{
    label: value.title,
    target: value
  }] : [];
  const label = isSubAggregation ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.aggSelect.subAggregationLabel",
    defaultMessage: "Sub aggregation"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.aggSelect.aggregationLabel",
    defaultMessage: "Aggregation"
  });
  let aggHelpLink;
  if ((0, _lodash.has)(value, 'name')) {
    // @ts-expect-error
    aggHelpLink = services.docLinks.links.aggs[value.name];
  }
  const helpLink = value && aggHelpLink && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: aggHelpLink,
    target: "_blank",
    rel: "noopener"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.aggSelect.helpLinkLabel",
    defaultMessage: "{aggTitle} help",
    values: {
      aggTitle: value ? value.title : ''
    }
  })));
  const errors = aggError ? [aggError] : [];
  if (!aggTypeOptions.length) {
    errors.push(_i18n.i18n.translate('visDefaultEditor.aggSelect.noCompatibleAggsDescription', {
      defaultMessage: 'The index pattern {indexPatternTitle} does not have any aggregatable fields.',
      values: {
        indexPatternTitle: indexPattern && indexPattern.title
      }
    }));
  }
  const isValid = !!value && !errors.length && !isDirty;
  const onChange = (0, _react.useCallback)(options => {
    const selectedOption = (0, _lodash.get)(options, '0.target');
    if (selectedOption) {
      setValue(selectedOption);
    }
  }, [setValue]);
  const onSearchChange = (0, _react.useCallback)(searchValue => setIsDirty(Boolean(searchValue)), []);
  const setTouched = (0, _react.useCallback)(() => onChangeAggType({
    type: _agg_params_state.AGG_TYPE_ACTION_KEYS.TOUCHED,
    payload: true
  }), [onChangeAggType]);
  const setValidity = (0, _react.useCallback)(valid => onChangeAggType({
    type: _agg_params_state.AGG_TYPE_ACTION_KEYS.VALID,
    payload: valid
  }), [onChangeAggType]);
  (0, _react.useEffect)(() => {
    setValidity(isValid);
  }, [isValid, setValidity]);
  (0, _react.useEffect)(() => {
    if (errors.length) {
      setTouched();
    }
  }, [errors.length, setTouched]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    labelAppend: helpLink,
    error: errors,
    isInvalid: showValidation ? !isValid : false,
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('visDefaultEditor.aggSelect.selectAggPlaceholder', {
      defaultMessage: 'Select an aggregation'
    }),
    id: `visDefaultEditorAggSelect${id}`,
    isDisabled: !aggTypeOptions.length,
    options: aggTypeOptions,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    onBlur: setTouched,
    onChange: onChange,
    onSearchChange: onSearchChange,
    "data-test-subj": "defaultEditorAggSelect",
    isClearable: false,
    isInvalid: showValidation ? !isValid : false,
    fullWidth: true,
    sortMatchesBy: "startsWith",
    compressed: true
  }));
}