"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.jsErrorsQuery = jsErrorsQuery;
var _merge_projection = require("../../../common/utils/merge_projection");
var _elasticsearch_fieldnames = require("../../../common/elasticsearch_fieldnames");
var _transaction_types = require("../../../common/transaction_types");
var _projections = require("./projections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function jsErrorsQuery(start, end, pageSize, pageIndex, urlQuery, uiFilters) {
  const setup = {
    uiFilters: uiFilters ? uiFilters : {}
  };
  const projection = (0, _projections.getRumErrorsProjection)({
    setup,
    urlQuery,
    start,
    end
  });
  const params = (0, _merge_projection.mergeProjection)(projection, {
    body: {
      size: 0,
      track_total_hits: true,
      aggs: {
        totalErrorGroups: {
          cardinality: {
            field: _elasticsearch_fieldnames.ERROR_GROUP_ID
          }
        },
        totalErrorPages: {
          cardinality: {
            field: _elasticsearch_fieldnames.TRANSACTION_ID
          }
        },
        errors: {
          terms: {
            field: _elasticsearch_fieldnames.ERROR_GROUP_ID,
            size: 500
          },
          aggs: {
            bucket_truncate: {
              bucket_sort: {
                size: pageSize,
                from: pageIndex * pageSize
              }
            },
            impactedPages: {
              filter: {
                term: {
                  [_elasticsearch_fieldnames.TRANSACTION_TYPE]: _transaction_types.TRANSACTION_PAGE_LOAD
                }
              },
              aggs: {
                pageCount: {
                  cardinality: {
                    field: _elasticsearch_fieldnames.TRANSACTION_ID
                  }
                }
              }
            },
            sample: {
              top_hits: {
                _source: [_elasticsearch_fieldnames.ERROR_EXC_MESSAGE, _elasticsearch_fieldnames.ERROR_EXC_TYPE, _elasticsearch_fieldnames.ERROR_GROUP_ID, '@timestamp'],
                sort: [{
                  '@timestamp': 'desc'
                }],
                size: 1
              }
            }
          }
        }
      }
    }
  });
  return params;
}