"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisitorBreakdown = VisitorBreakdown;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _ux_ui_filter = require("../../../../../common/ux_ui_filter");
var _visitor_breakdown_chart = require("../charts/visitor_breakdown_chart");
var _translations = require("../translations");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_local_uifilters = require("../hooks/use_local_uifilters");
var _local_uifilters = require("../local_uifilters");
var _use_data_view = require("../local_uifilters/use_data_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const visitorBreakdownFieldMap = {
  [_visitor_breakdown_chart.VisitorBreakdownMetric.OS_BREAKDOWN]: 'os',
  [_visitor_breakdown_chart.VisitorBreakdownMetric.UA_BREAKDOWN]: 'browser'
};
const EuiLoadingEmbeddable = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  & {
    min-height: 100%;
    min-width: 100%;
  }
`;
const vistorBreakdownFilter = {
  filterNames: _ux_ui_filter.uxLocalUIFilterNames.filter(name => ['browser', 'browserExcluded', 'os', 'osExcluded'].includes(name))
};
const getInvertedFilterName = (filter, negate) => negate ? filter : (0, _local_uifilters.getExcludedName)(filter);
function VisitorBreakdown() {
  const {
    urlParams,
    uxUiFilters
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    start,
    end,
    searchTerm
  } = urlParams;
  const {
    dataView
  } = (0, _use_data_view.useDataView)();
  const {
    filters,
    setFilterValue
  } = (0, _use_local_uifilters.useLocalUIFilters)(vistorBreakdownFilter);
  const onFilter = (0, _react.useCallback)((metric, event) => {
    var _event$data, _event$negate, _filters$find$value, _filters$find;
    if (!visitorBreakdownFieldMap[metric]) {
      return;
    }
    const filterValues = event === null || event === void 0 ? void 0 : (_event$data = event.data) === null || _event$data === void 0 ? void 0 : _event$data.map(fdata => fdata.value);
    const invertedField = getInvertedFilterName(visitorBreakdownFieldMap[metric], (_event$negate = event === null || event === void 0 ? void 0 : event.negate) !== null && _event$negate !== void 0 ? _event$negate : false);
    const invertedFieldValues = (_filters$find$value = filters === null || filters === void 0 ? void 0 : (_filters$find = filters.find(filter => filter.name === invertedField)) === null || _filters$find === void 0 ? void 0 : _filters$find.value) !== null && _filters$find$value !== void 0 ? _filters$find$value : [];
    setFilterValue(invertedField, invertedFieldValues.filter(value => !filterValues.includes(value)));
    setFilterValue(event !== null && event !== void 0 && event.negate ? (0, _local_uifilters.getExcludedName)(visitorBreakdownFieldMap[metric]) : visitorBreakdownFieldMap[metric], filterValues);
  }, [filters, setFilterValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _translations.VisitorBreakdownLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      height: 'calc(100% - 32px)'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _translations.I18LABELS.browser)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !(dataView !== null && dataView !== void 0 && dataView.id) ? /*#__PURE__*/_react.default.createElement(EuiLoadingEmbeddable, {
    justifyContent: "spaceAround",
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "l",
    mono: true
  }))) : /*#__PURE__*/_react.default.createElement(_visitor_breakdown_chart.VisitorBreakdownChart, {
    dataView: dataView,
    start: start !== null && start !== void 0 ? start : '',
    end: end !== null && end !== void 0 ? end : '',
    uiFilters: uxUiFilters,
    urlQuery: searchTerm,
    metric: _visitor_breakdown_chart.VisitorBreakdownMetric.UA_BREAKDOWN,
    onFilter: onFilter
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _translations.I18LABELS.operatingSystem)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), !(dataView !== null && dataView !== void 0 && dataView.id) ? /*#__PURE__*/_react.default.createElement(EuiLoadingEmbeddable, {
    justifyContent: "spaceAround",
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "l",
    mono: true
  }))) : /*#__PURE__*/_react.default.createElement(_visitor_breakdown_chart.VisitorBreakdownChart, {
    dataView: dataView,
    start: start !== null && start !== void 0 ? start : '',
    end: end !== null && end !== void 0 ? end : '',
    uiFilters: uxUiFilters,
    urlQuery: searchTerm,
    metric: _visitor_breakdown_chart.VisitorBreakdownMetric.OS_BREAKDOWN,
    onFilter: onFilter
  }))));
}