"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedWildcards = SelectedWildcards;
var React = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SelectedWildcards({
  indexPattern
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    urlParams: {
      searchTerm
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const updateSearchTerm = (0, React.useCallback)(searchTermN => {
    const newQuery = {
      ...(0, _public.toQuery)(history.location.search),
      searchTerm: searchTermN || undefined
    };
    if (!searchTermN) {
      delete newQuery.searchTerm;
    }
    const newLocation = {
      ...history.location,
      search: (0, _public.fromQuery)(newQuery)
    };
    history.push(newLocation);
  }, [history]);
  return searchTerm ? /*#__PURE__*/React.createElement(_public2.FilterValueLabel, {
    dataView: indexPattern,
    removeFilter: () => {
      updateSearchTerm('');
    },
    invertFilter: ({
      negate
    }) => {},
    field: _elasticsearch_fieldnames.TRANSACTION_URL,
    value: searchTerm,
    negate: false,
    label: 'URL wildcard'
  }) : null;
}