"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLocalUIFilters = useLocalUIFilters;
var _lodash = require("lodash");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-plugin/public");
var _react = require("react");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _local_uifilters = require("../local_uifilters");
var _helpers = require("../../../../context/url_params_context/helpers");
var _ux_ui_filter = require("../../../../../common/ux_ui_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLocalUIFilters({
  filterNames
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    uxUiFilters
  } = (0, _use_url_params.useLegacyUrlParams)();
  const setFilterValue = (0, _react.useCallback)((name, value) => {
    const search = (0, _lodash.omit)((0, _public.toQuery)(history.location.search), name);
    history.push({
      ...history.location,
      search: (0, _public.fromQuery)((0, _helpers.removeUndefinedProps)({
        ...search,
        [name]: value.length ? value.join(',') : undefined
      }))
    });
  }, [history]);
  const invertFilter = (0, _react.useCallback)((name, value, negate) => {
    if (!negate) {
      var _uxUiFilters$excluded;
      setFilterValue(name, (uxUiFilters === null || uxUiFilters === void 0 ? void 0 : uxUiFilters[name]).filter(valT => valT !== value));
      const excludedName = (0, _local_uifilters.getExcludedName)(name);
      setFilterValue(excludedName, [...((_uxUiFilters$excluded = uxUiFilters === null || uxUiFilters === void 0 ? void 0 : uxUiFilters[excludedName]) !== null && _uxUiFilters$excluded !== void 0 ? _uxUiFilters$excluded : []), value]);
    } else {
      var _uxUiFilters$includeN;
      const includeName = name.split('Excluded')[0];
      const excludedName = name;
      setFilterValue(excludedName, (uxUiFilters === null || uxUiFilters === void 0 ? void 0 : uxUiFilters[excludedName]).filter(valT => valT !== value));
      setFilterValue(includeName, [...((_uxUiFilters$includeN = uxUiFilters === null || uxUiFilters === void 0 ? void 0 : uxUiFilters[includeName]) !== null && _uxUiFilters$includeN !== void 0 ? _uxUiFilters$includeN : []), value]);
    }
  }, [setFilterValue, uxUiFilters]);
  const clearValues = (0, _react.useCallback)(() => {
    const search = (0, _lodash.omit)((0, _public.toQuery)(history.location.search), [...filterNames, 'searchTerm', 'transactionUrl']);
    history.push({
      ...history.location,
      search: (0, _public.fromQuery)(search)
    });
  }, [filterNames, history]);
  const filters = (0, _react.useMemo)(() => filterNames.map(name => {
    var _ref;
    return {
      value: (_ref = uxUiFilters[name]) !== null && _ref !== void 0 ? _ref : [],
      ..._ux_ui_filter.uxFiltersByName[name],
      name
    };
  }), [filterNames, uxUiFilters]);
  return {
    filters,
    setFilterValue,
    clearValues,
    invertFilter
  };
}