"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getContextVariableList = exports.getContextScopeValues = void 0;
exports.getEmbeddableVariables = getEmbeddableVariables;
var _i18n = require("@kbn/i18n");
var _monaco = require("@kbn/monaco");
var _std = require("@kbn/std");
var _i18n2 = require("./i18n");
var _util = require("./util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function hasSavedObjectId(obj) {
  return 'savedObjectId' in obj && typeof obj.savedObjectId === 'string';
}

/**
 * @todo Same functionality is implemented in x-pack/plugins/discover_enhanced/public/actions/explore_data/shared.ts,
 *       combine both implementations into a common approach.
 */
function getIndexPatternIds(output) {
  function hasIndexPatterns(_output) {
    return typeof _output === 'object' && !!_output && Array.isArray(_output.indexPatterns) && _output.indexPatterns.length > 0;
  }
  return hasIndexPatterns(output) ? output.indexPatterns.map(ip => ip.id).filter(Boolean) : [];
}
function getEmbeddableVariables(embeddable) {
  var _output$title, _output$savedObjectId;
  const input = embeddable.getInput();
  const output = embeddable.getOutput();
  const indexPatternsIds = getIndexPatternIds(output);
  return (0, _util.deleteUndefinedKeys)({
    id: input.id,
    title: (_output$title = output.title) !== null && _output$title !== void 0 ? _output$title : input.title,
    savedObjectId: (_output$savedObjectId = output.savedObjectId) !== null && _output$savedObjectId !== void 0 ? _output$savedObjectId : hasSavedObjectId(input) ? input.savedObjectId : undefined,
    query: input.query,
    timeRange: input.timeRange,
    filters: input.filters,
    indexPatternIds: indexPatternsIds.length > 1 ? indexPatternsIds : undefined,
    indexPatternId: indexPatternsIds.length === 1 ? indexPatternsIds[0] : undefined
  });
}
const getContextPanelScopeValues = contextScopeInput => {
  function hasEmbeddable(val) {
    if (val && typeof val === 'object' && 'embeddable' in val) return true;
    return false;
  }
  if (!hasEmbeddable(contextScopeInput)) throw new Error("UrlDrilldown [getContextScope] can't build scope because embeddable object is missing in context");
  const embeddable = contextScopeInput.embeddable;
  return getEmbeddableVariables(embeddable);
};
const getContextScopeValues = contextScopeInput => {
  return {
    panel: getContextPanelScopeValues(contextScopeInput)
  };
};
exports.getContextScopeValues = getContextScopeValues;
const variableDescriptions = {
  id: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.id.title', {
      defaultMessage: 'Panel ID.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.id.documentation', {
      defaultMessage: 'ID of the panel where drilldown is executed.'
    })
  },
  title: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.title.title', {
      defaultMessage: 'Panel title.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.title.documentation', {
      defaultMessage: 'Title of the panel where drilldown is executed.'
    })
  },
  filters: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.filters.title', {
      defaultMessage: 'Panel filters.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.filters.documentation', {
      defaultMessage: 'List of Kibana filters applied to a panel.'
    })
  },
  'query.query': {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.query.query.title', {
      defaultMessage: 'Query string.'
    })
  },
  'query.language': {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.query.language.title', {
      defaultMessage: 'Query language.'
    })
  },
  'timeRange.from': {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.from.title', {
      defaultMessage: 'Time picker "from" value.'
    })
  },
  'timeRange.to': {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.to.title', {
      defaultMessage: 'Time picker "to" value.'
    })
  },
  indexPatternId: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.indexPatternId.title', {
      defaultMessage: 'Index pattern ID.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.indexPatternId.documentation', {
      defaultMessage: 'First index pattern ID used by the panel.'
    })
  },
  indexPatternIds: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.indexPatternIds.title', {
      defaultMessage: 'Index pattern IDs.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.timeRange.indexPatternIds.documentation', {
      defaultMessage: 'List of all index pattern IDs used by the panel.'
    })
  },
  savedObjectId: {
    title: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.savedObjectId.title', {
      defaultMessage: 'Saved object ID.'
    }),
    documentation: _i18n.i18n.translate('xpack.urlDrilldown.context.panel.savedObjectId.documentation', {
      defaultMessage: 'ID of the saved object behind the panel.'
    })
  }
};
const kind = _monaco.monaco.languages.CompletionItemKind.Variable;
const sortPrefix = '2.';
const formatValue = value => {
  if (typeof value === 'object') {
    return '\n' + JSON.stringify(value, null, 4);
  }
  return String(value);
};
const getPanelVariableList = values => {
  const variables = [];
  const flattenedValues = (0, _std.getFlattenedObject)(values);
  const keys = Object.keys(flattenedValues).sort();
  for (const key of keys) {
    const description = variableDescriptions[key];
    const label = 'context.panel.' + key;
    if (!description) {
      variables.push({
        label,
        sortText: sortPrefix + label,
        documentation: !!flattenedValues[key] ? (0, _i18n2.txtValue)(formatValue(flattenedValues[key])) : '',
        kind
      });
      continue;
    }
    variables.push({
      label,
      sortText: sortPrefix + label,
      title: description.title,
      documentation: (description.documentation || '') + (!!description.documentation && !!flattenedValues[key] ? '\n\n' : '') + (!!flattenedValues[key] ? (0, _i18n2.txtValue)(formatValue(flattenedValues[key])) : ''),
      kind
    });
  }
  return variables;
};
const getContextVariableList = context => {
  const values = getContextScopeValues(context);
  const variables = getPanelVariableList(values.panel);
  return variables;
};
exports.getContextVariableList = getContextVariableList;