"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogsStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _shared_imports = require("../../../../shared_imports");
var _app_context = require("../../../app_context");
var _logs_checkpoint = require("../../../lib/logs_checkpoint");
var _es_deprecation_logs = require("../../es_deprecation_logs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  logsStepTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.title', {
    defaultMessage: 'Address API deprecations'
  }),
  logsStepDescription: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.description', {
    defaultMessage: `Review the Elasticsearch deprecation logs to ensure you're not using deprecated APIs.`
  }),
  viewLogsButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.viewLogsButtonLabel', {
    defaultMessage: 'View logs'
  }),
  enableLogsButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.enableLogsButtonLabel', {
    defaultMessage: 'Enable logging'
  }),
  logsCountDescription: (deprecationCount, checkpoint) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.overview.logsStep.countDescription",
    defaultMessage: "You have {deprecationCount, plural, =0 {no} other {{deprecationCount}}} deprecation {deprecationCount, plural, one {issue} other {issues}} since {checkpoint}.",
    values: {
      deprecationCount,
      checkpoint: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
        value: checkpoint,
        year: "numeric",
        month: "long",
        day: "2-digit"
      }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
        value: checkpoint,
        timeZoneName: "short",
        hour12: false
      }))
    }
  }),
  missingPrivilegesTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.missingPrivilegesTitle', {
    defaultMessage: 'You require index privileges to analyze the deprecation logs'
  }),
  missingPrivilegesDescription: privilegesMissing => {
    var _privilegesMissing$in, _privilegesMissing$in2;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.overview.logsStep.missingPrivilegesDescription",
      defaultMessage: "The deprecation logs will continue to be indexed, but you won't be able to analyze them until you have the read index {privilegesCount, plural, one {privilege} other {privileges}} for: {missingPrivileges}",
      values: {
        missingPrivileges: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          transparentBackground: true
        }, privilegesMissing === null || privilegesMissing === void 0 ? void 0 : (_privilegesMissing$in = privilegesMissing.index) === null || _privilegesMissing$in === void 0 ? void 0 : _privilegesMissing$in.join(', ')),
        privilegesCount: privilegesMissing === null || privilegesMissing === void 0 ? void 0 : (_privilegesMissing$in2 = privilegesMissing.index) === null || _privilegesMissing$in2 === void 0 ? void 0 : _privilegesMissing$in2.length
      }
    });
  },
  loadingError: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.loadingError', {
    defaultMessage: 'An error occurred while retrieving the deprecation log count'
  }),
  retryButton: _i18n.i18n.translate('xpack.upgradeAssistant.overview.logsStep.retryButton', {
    defaultMessage: 'Try again'
  })
};
const LogStepDescription = () => /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.logsStepDescription));
const LogsStep = ({
  setIsComplete,
  hasPrivileges,
  privilegesMissing,
  navigateToEsDeprecationLogs
}) => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    isDeprecationLogIndexingEnabled
  } = (0, _es_deprecation_logs.useDeprecationLogging)();
  const checkpoint = (0, _logs_checkpoint.loadLogsCheckpoint)();
  const {
    data: logsCount,
    error,
    isLoading,
    resendRequest,
    isInitialRequest
  } = api.getDeprecationLogsCount(checkpoint);
  (0, _react.useEffect)(() => {
    if (!isDeprecationLogIndexingEnabled) {
      setIsComplete(false);
    }
    setIsComplete((logsCount === null || logsCount === void 0 ? void 0 : logsCount.count) === 0);

    // Depending upon setIsComplete would create an infinite loop.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isDeprecationLogIndexingEnabled, logsCount]);
  if (hasPrivileges === false && isDeprecationLogIndexingEnabled) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LogStepDescription, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "help",
      color: "warning",
      title: i18nTexts.missingPrivilegesTitle,
      "data-test-subj": "missingPrivilegesCallout"
    }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.missingPrivilegesDescription(privilegesMissing))));
  }
  if (isLoading && isInitialRequest) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 3
    });
  }
  if (hasPrivileges && error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: i18nTexts.loadingError,
      color: "danger",
      iconType: "warning",
      "data-test-subj": "deprecationLogsErrorCallout"
    }, /*#__PURE__*/_react.default.createElement("p", null, error.statusCode, " - ", error.message), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "danger",
      onClick: resendRequest,
      "data-test-subj": "deprecationLogsRetryButton"
    }, i18nTexts.retryButton));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(LogStepDescription, null), isDeprecationLogIndexingEnabled && logsCount ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "logsCountDescription"
  }, i18nTexts.logsCountDescription(logsCount.count, checkpoint))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: navigateToEsDeprecationLogs,
    "data-test-subj": "viewLogsLink"
  }, i18nTexts.viewLogsButtonLabel)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: navigateToEsDeprecationLogs,
    "data-test-subj": "enableLogsLink"
  }, i18nTexts.enableLogsButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
const getLogsStep = ({
  isComplete,
  setIsComplete,
  navigateToEsDeprecationLogs
}) => {
  const status = isComplete ? 'complete' : 'incomplete';
  return {
    status,
    title: i18nTexts.logsStepTitle,
    'data-test-subj': `logsStep-${status}`,
    children: /*#__PURE__*/_react.default.createElement(_shared_imports.WithPrivileges, {
      privileges: `index.${_constants.DEPRECATION_LOGS_INDEX}`
    }, ({
      hasPrivileges,
      isLoading,
      privilegesMissing
    }) => /*#__PURE__*/_react.default.createElement(LogsStep, {
      setIsComplete: setIsComplete,
      hasPrivileges: !isLoading && hasPrivileges,
      navigateToEsDeprecationLogs: navigateToEsDeprecationLogs,
      privilegesMissing: privilegesMissing
    }))
  };
};
exports.getLogsStep = getLogsStep;