"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsDeprecationIssuesPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _app_context = require("../../../../app_context");
var _get_es_deprecation_error = require("../../../../lib/get_es_deprecation_error");
var _deprecation_issues_panel = require("./deprecation_issues_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EsDeprecationIssuesPanel = ({
  setIsFixed
}) => {
  var _esDeprecations$depre, _esDeprecations$depre2, _esDeprecations$depre3, _esDeprecations$depre4, _esDeprecations$depre5, _esDeprecations$depre6;
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    data: esDeprecations,
    isLoading,
    error
  } = api.useLoadEsDeprecations();
  const criticalDeprecationsCount = (_esDeprecations$depre = esDeprecations === null || esDeprecations === void 0 ? void 0 : (_esDeprecations$depre2 = esDeprecations.deprecations) === null || _esDeprecations$depre2 === void 0 ? void 0 : (_esDeprecations$depre3 = _esDeprecations$depre2.filter(deprecation => deprecation.isCritical)) === null || _esDeprecations$depre3 === void 0 ? void 0 : _esDeprecations$depre3.length) !== null && _esDeprecations$depre !== void 0 ? _esDeprecations$depre : 0;
  const warningDeprecationsCount = (_esDeprecations$depre4 = esDeprecations === null || esDeprecations === void 0 ? void 0 : (_esDeprecations$depre5 = esDeprecations.deprecations) === null || _esDeprecations$depre5 === void 0 ? void 0 : (_esDeprecations$depre6 = _esDeprecations$depre5.filter(deprecation => deprecation.isCritical === false)) === null || _esDeprecations$depre6 === void 0 ? void 0 : _esDeprecations$depre6.length) !== null && _esDeprecations$depre4 !== void 0 ? _esDeprecations$depre4 : 0;
  const errorMessage = error && (0, _get_es_deprecation_error.getEsDeprecationError)(error).message;
  return /*#__PURE__*/_react.default.createElement(_deprecation_issues_panel.DeprecationIssuesPanel, {
    "data-test-subj": "esStatsPanel",
    deprecationSource: "Elasticsearch",
    linkUrl: "/es_deprecations",
    criticalDeprecationsCount: criticalDeprecationsCount,
    warningDeprecationsCount: warningDeprecationsCount,
    isLoading: isLoading,
    errorMessage: errorMessage,
    setIsFixed: setIsFixed
  });
};
exports.EsDeprecationIssuesPanel = EsDeprecationIssuesPanel;