"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsDeprecations = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _shared_imports = require("../../../shared_imports");
var _app_context = require("../../app_context");
var _ui_metric = require("../../lib/ui_metric");
var _get_es_deprecation_error = require("../../lib/get_es_deprecation_error");
var _shared = require("../shared");
var _es_deprecations_table = require("./es_deprecations_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDeprecationCountByLevel = deprecations => {
  const criticalDeprecations = [];
  const warningDeprecations = [];
  deprecations.forEach(deprecation => {
    if (deprecation.isCritical) {
      criticalDeprecations.push(deprecation);
      return;
    }
    warningDeprecations.push(deprecation);
  });
  return {
    criticalDeprecations: criticalDeprecations.length,
    warningDeprecations: warningDeprecations.length
  };
};
const i18nTexts = {
  pageTitle: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.pageTitle', {
    defaultMessage: 'Elasticsearch deprecation issues'
  }),
  pageDescription: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.pageDescription', {
    defaultMessage: 'Resolve all critical issues before upgrading. Before making changes, ensure you have a current snapshot of your cluster.'
  }),
  isLoading: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.loadingText', {
    defaultMessage: 'Loading deprecation issues…'
  }),
  remoteClustersDetectedTitle: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.remoteClustersDetectedTitle', {
    defaultMessage: 'Remote cluster compatibility'
  }),
  getRemoteClustersDetectedDescription: remoteClustersCount => _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.remoteClustersDetectedDescription', {
    defaultMessage: 'You have {remoteClustersCount} {remoteClustersCount, plural, one {remote cluster} other {remote clusters}} configured. If you use cross-cluster search, note that 8.x can only search remote clusters running the previous minor version or later. If you use cross-cluster replication, a cluster that contains follower indices must run the same or newer version as the remote cluster.',
    values: {
      remoteClustersCount
    }
  }),
  remoteClustersLinkText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.remoteClustersLinkText', {
    defaultMessage: 'View remote clusters.'
  })
};
const getBatchReindexLink = docLinks => {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.batchReindexingDocsDescription",
    defaultMessage: "To start multiple reindexing tasks in a single request, use the Kibana {docsLink}.",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.upgradeAssistant.batchReindex,
        target: "_blank",
        external: true
      }, _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.batchReindexingDocsLink', {
        defaultMessage: 'batch reindexing API'
      }))
    }
  });
};
const RemoteClustersAppLink = () => {
  var _share$url$locators$g;
  const {
    plugins: {
      share
    }
  } = (0, _app_context.useAppContext)();
  const remoteClustersUrl = (_share$url$locators$g = share.url.locators.get('REMOTE_CLUSTERS_LOCATOR')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({
    page: 'remoteClusters'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: remoteClustersUrl,
    "data-test-subj": "remoteClustersLink"
  }, i18nTexts.remoteClustersLinkText);
};
const EsDeprecations = (0, _reactRouterDom.withRouter)(({
  history
}) => {
  var _esDeprecations$depre;
  const {
    services: {
      api,
      breadcrumbs,
      core: {
        docLinks
      }
    }
  } = (0, _app_context.useAppContext)();
  const {
    data: esDeprecations,
    isLoading,
    error,
    resendRequest
  } = api.useLoadEsDeprecations();
  const {
    data: remoteClusters
  } = api.useLoadRemoteClusters();
  const deprecationsCountByLevel = (0, _react.useMemo)(() => getDeprecationCountByLevel((esDeprecations === null || esDeprecations === void 0 ? void 0 : esDeprecations.deprecations) || []), [esDeprecations === null || esDeprecations === void 0 ? void 0 : esDeprecations.deprecations]);
  (0, _react.useEffect)(() => {
    breadcrumbs.setBreadcrumbs('esDeprecations');
  }, [breadcrumbs]);
  (0, _react.useEffect)(() => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.LOADED, _ui_metric.UIM_ES_DEPRECATIONS_PAGE_LOAD);
  }, []);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_shared.DeprecationsPageLoadingError, {
      deprecationSource: "Elasticsearch",
      message: (0, _get_es_deprecation_error.getEsDeprecationError)(error).message
    });
  }
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      verticalPosition: "center",
      horizontalPosition: "center",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, i18nTexts.isLoading));
  }
  if ((esDeprecations === null || esDeprecations === void 0 ? void 0 : (_esDeprecations$depre = esDeprecations.deprecations) === null || _esDeprecations$depre === void 0 ? void 0 : _esDeprecations$depre.length) === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      verticalPosition: "center",
      horizontalPosition: "center",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_shared.NoDeprecationsPrompt, {
      deprecationType: "Elasticsearch",
      navigateToOverviewPage: () => history.push('/overview')
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "esDeprecationsContent"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: i18nTexts.pageTitle,
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18nTexts.pageDescription, " ", getBatchReindexLink(docLinks))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, remoteClusters && remoteClusters.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.remoteClustersDetectedTitle,
    color: "warning",
    iconType: "help",
    "data-test-subj": "remoteClustersWarningCallout"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.getRemoteClustersDetectedDescription(remoteClusters.length), ' ', /*#__PURE__*/_react.default.createElement(RemoteClustersAppLink, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_shared.DeprecationCount, {
    totalCriticalDeprecations: deprecationsCountByLevel.criticalDeprecations,
    totalWarningDeprecations: deprecationsCountByLevel.warningDeprecations
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_es_deprecations_table.EsDeprecationsTable, {
    deprecations: esDeprecations === null || esDeprecations === void 0 ? void 0 : esDeprecations.deprecations,
    reload: resendRequest
  }));
});
exports.EsDeprecations = EsDeprecations;