"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasReindexWarning = exports.ReplaceIndexWithAliasWarningCheckbox = exports.DeprecatedSettingWarningCheckbox = exports.CustomTypeNameWarningCheckbox = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasReindexWarning = (warnings, warningType) => {
  return Boolean(warnings.find(warning => warning.warningType === warningType));
};
exports.hasReindexWarning = hasReindexWarning;
const WarningCheckbox = ({
  isChecked,
  warningId,
  label,
  onChange,
  description,
  documentationUrl
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  justifyContent: "spaceBetween"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
  id: warningId,
  label: /*#__PURE__*/_react.default.createElement("strong", null, label),
  checked: isChecked,
  onChange: onChange
})), documentationUrl !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: documentationUrl,
  target: "_blank",
  external: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.documentationLinkLabel",
    defaultMessage: "Documentation"
  }),
  position: "right",
  type: "help"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "xs"
}), description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
const CustomTypeNameWarningCheckbox = ({
  isChecked,
  onChange,
  docLinks,
  id,
  meta
}) => {
  return /*#__PURE__*/_react.default.createElement(WarningCheckbox, {
    isChecked: isChecked,
    onChange: onChange,
    warningId: id,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.customTypeNameWarningTitle",
      defaultMessage: "Replace mapping type {mappingType} with {defaultType}",
      values: {
        mappingType: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta.typeName),
        defaultType: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "_doc")
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.customTypeNameWarningDetail",
      defaultMessage: "Mapping types are no longer supported in Elastic 8.x. Ensure no application code or scripts rely on {mappingType}.",
      values: {
        mappingType: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta.typeName)
      }
    }),
    documentationUrl: docLinks.elasticsearch.typesRemoval
  });
};
exports.CustomTypeNameWarningCheckbox = CustomTypeNameWarningCheckbox;
const DeprecatedSettingWarningCheckbox = ({
  isChecked,
  onChange,
  docLinks,
  id,
  meta
}) => {
  return /*#__PURE__*/_react.default.createElement(WarningCheckbox, {
    isChecked: isChecked,
    onChange: onChange,
    warningId: id,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.deprecatedIndexSettingsWarningTitle",
      defaultMessage: "Remove deprecated index settings"
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.deprecatedIndexSettingsWarningDetail",
      defaultMessage: "The following deprecated index settings were detected:"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("ul", null, meta.deprecatedSettings.map((setting, index) => {
      return /*#__PURE__*/_react.default.createElement("li", {
        key: `${setting}-${index}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, setting));
    }))),
    documentationUrl: docLinks.elasticsearch.indexModules
  });
};
exports.DeprecatedSettingWarningCheckbox = DeprecatedSettingWarningCheckbox;
const ReplaceIndexWithAliasWarningCheckbox = ({
  isChecked,
  onChange,
  docLinks,
  id,
  meta
}) => {
  return /*#__PURE__*/_react.default.createElement(WarningCheckbox, {
    isChecked: isChecked,
    onChange: onChange,
    warningId: id,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.replaceIndexWithAliasWarningTitle",
      defaultMessage: "Replace {indexName} index with {reindexName} index and create {indexName} index alias",
      values: {
        indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta === null || meta === void 0 ? void 0 : meta.indexName),
        reindexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta === null || meta === void 0 ? void 0 : meta.reindexName)
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.checkupTab.reindexing.flyout.warningsStep.replaceIndexWithAliasWarningDetail",
      defaultMessage: "You can search {indexName} as before. To delete the data you'll have to delete {reindexName}",
      values: {
        indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta === null || meta === void 0 ? void 0 : meta.indexName),
        reindexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, meta === null || meta === void 0 ? void 0 : meta.reindexName)
      }
    })
  });
};
exports.ReplaceIndexWithAliasWarningCheckbox = ReplaceIndexWithAliasWarningCheckbox;