"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexSettingsTableRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _app_context = require("../../../../app_context");
var _es_deprecations_table_cells = require("../../es_deprecations_table_cells");
var _resolution_table_cell = require("./resolution_table_cell");
var _flyout = require("./flyout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  useGlobalFlyout
} = _shared_imports.GlobalFlyout;
const IndexSettingsTableRow = ({
  rowFieldNames,
  deprecation
}) => {
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const [status, setStatus] = (0, _react.useState)({
    statusType: 'idle'
  });
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    addContent: addContentToGlobalFlyout,
    removeContent: removeContentFromGlobalFlyout
  } = useGlobalFlyout();
  const closeFlyout = (0, _react.useCallback)(() => {
    setShowFlyout(false);
    removeContentFromGlobalFlyout('indexSettingsFlyout');
  }, [removeContentFromGlobalFlyout]);
  const removeIndexSettings = (0, _react.useCallback)(async (index, settings) => {
    setStatus({
      statusType: 'in_progress'
    });
    const {
      error
    } = await api.updateIndexSettings(index, settings);
    setStatus({
      statusType: error ? 'error' : 'complete',
      details: error !== null && error !== void 0 ? error : undefined
    });
    closeFlyout();
  }, [api, closeFlyout]);
  (0, _react.useEffect)(() => {
    if (showFlyout) {
      addContentToGlobalFlyout({
        id: 'indexSettingsFlyout',
        Component: _flyout.RemoveIndexSettingsFlyout,
        props: {
          closeFlyout,
          deprecation,
          removeIndexSettings,
          status
        },
        flyoutProps: {
          onClose: closeFlyout,
          className: 'eui-textBreakWord',
          'data-test-subj': 'indexSettingsDetails',
          'aria-labelledby': 'indexSettingsDetailsFlyoutTitle'
        }
      });
    }
  }, [addContentToGlobalFlyout, deprecation, removeIndexSettings, showFlyout, closeFlyout, status]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, rowFieldNames.map(field => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      key: field,
      truncateText: false,
      "data-test-subj": `indexSettingsTableCell-${field}`
    }, /*#__PURE__*/_react.default.createElement(_es_deprecations_table_cells.EsDeprecationsTableCells, {
      fieldName: field,
      openFlyout: () => setShowFlyout(true),
      deprecation: deprecation,
      resolutionTableCell: /*#__PURE__*/_react.default.createElement(_resolution_table_cell.IndexSettingsResolutionCell, {
        status: status
      })
    }));
  }));
};
exports.IndexSettingsTableRow = IndexSettingsTableRow;