"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = TextBasedLanguagesList;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Needed for React.lazy
// eslint-disable-next-line import/no-default-export
function TextBasedLanguagesList({
  textBasedLanguages,
  onChange,
  selectedOption
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    key: "textbasedLanguages-options",
    "data-test-subj": "text-based-languages-switcher",
    singleSelection: "always",
    options: textBasedLanguages.map(lang => ({
      key: lang,
      label: lang,
      value: lang,
      checked: lang === selectedOption ? 'on' : undefined,
      append: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, _i18n.i18n.translate('unifiedSearch.query.queryBar.textBasedLanguagesTechPreviewLabel', {
        defaultMessage: 'Technical preview'
      }))
    })),
    onChange: choices => {
      const choice = choices.find(({
        checked
      }) => checked);
      onChange(choice.value);
    }
  }, list => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "none"
  }, list));
}
module.exports = exports.default;