"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ACTION_GLOBAL_APPLY_FILTER = void 0;
exports.createFilterAction = createFilterAction;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _services = require("../services");
var _apply_filters = require("../apply_filters");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const ACTION_GLOBAL_APPLY_FILTER = 'ACTION_GLOBAL_APPLY_FILTER';
exports.ACTION_GLOBAL_APPLY_FILTER = ACTION_GLOBAL_APPLY_FILTER;
async function isCompatible(context) {
  return context.filters !== undefined;
}
function createFilterAction(filterManager, timeFilter, theme) {
  return {
    type: ACTION_GLOBAL_APPLY_FILTER,
    id: ACTION_GLOBAL_APPLY_FILTER,
    order: 100,
    getIconType: () => 'filter',
    getDisplayName: () => {
      return _i18n.i18n.translate('unifiedSearch.filter.applyFilterActionTitle', {
        defaultMessage: 'Apply filter to current view'
      });
    },
    isCompatible,
    execute: async ({
      filters,
      timeFieldName,
      controlledBy
    }) => {
      if (!filters) {
        throw new Error('Applying a filter requires a filter');
      }
      if (!(await isCompatible({
        filters
      }))) {
        throw new _public2.IncompatibleActionError();
      }
      let selectedFilters = filters;
      if (selectedFilters.length > 1) {
        const indexPatterns = await Promise.all(filters.map(filter => {
          return (0, _services.getIndexPatterns)().get(filter.meta.index);
        }));
        const filterSelectionPromise = new Promise(resolve => {
          const overlay = (0, _services.getOverlays)().openModal((0, _public.toMountPoint)((0, _apply_filters.applyFiltersPopover)(filters, indexPatterns, () => {
            overlay.close();
            resolve([]);
          }, filterSelection => {
            overlay.close();
            resolve(filterSelection);
          }), {
            theme$: theme.theme$
          }), {
            'data-test-subj': 'test'
          });
        });
        selectedFilters = await filterSelectionPromise;
      }

      // remove existing filters for control prior to adding new filtes for control
      if (controlledBy) {
        filterManager.getFilters().forEach(filter => {
          if (filter.meta.controlledBy === controlledBy) {
            filterManager.removeFilter(filter);
          }
        });
      }
      if (timeFieldName) {
        const {
          extractTimeFilter
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
        const {
          timeRangeFilter,
          restOfFilters
        } = extractTimeFilter(timeFieldName, selectedFilters);
        filterManager.addFilters(restOfFilters);
        if (timeRangeFilter) {
          changeTimeFilter(timeFilter, timeRangeFilter);
        }
      } else {
        filterManager.addFilters(selectedFilters);
      }
    }
  };
}
async function changeTimeFilter(timeFilter, filter) {
  const {
    convertRangeFilterToTimeRange
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
  timeFilter.setTime(convertRangeFilterToTimeRange(filter));
}