"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useChartPanels = useChartPanels;
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function useChartPanels({
  chart,
  toggleHideChart,
  onTimeIntervalChange,
  closePopover,
  onResetChartHeight,
  isPlainRecord
}) {
  if (!chart) {
    return [];
  }
  const selectedOptionIdx = _public.search.aggs.intervalOptions.findIndex(opt => opt.val === chart.timeInterval);
  const intervalDisplay = selectedOptionIdx > -1 ? _public.search.aggs.intervalOptions[selectedOptionIdx].display : _public.search.aggs.intervalOptions[0].display;
  const mainPanelItems = [{
    name: !chart.hidden ? _i18n.i18n.translate('unifiedHistogram.hideChart', {
      defaultMessage: 'Hide chart'
    }) : _i18n.i18n.translate('unifiedHistogram.showChart', {
      defaultMessage: 'Show chart'
    }),
    icon: !chart.hidden ? 'eyeClosed' : 'eye',
    onClick: () => {
      toggleHideChart();
      closePopover();
    },
    'data-test-subj': 'unifiedHistogramChartToggle'
  }];
  if (!chart.hidden) {
    if (onResetChartHeight) {
      mainPanelItems.push({
        name: _i18n.i18n.translate('unifiedHistogram.resetChartHeight', {
          defaultMessage: 'Reset to default height'
        }),
        icon: 'refresh',
        onClick: () => {
          onResetChartHeight();
          closePopover();
        },
        'data-test-subj': 'unifiedHistogramChartResetHeight'
      });
    }
    if (!isPlainRecord) {
      mainPanelItems.push({
        name: _i18n.i18n.translate('unifiedHistogram.timeIntervalWithValue', {
          defaultMessage: 'Time interval: {timeInterval}',
          values: {
            timeInterval: intervalDisplay
          }
        }),
        panel: 1,
        'data-test-subj': 'unifiedHistogramTimeIntervalPanel'
      });
    }
  }
  const panels = [{
    id: 0,
    title: _i18n.i18n.translate('unifiedHistogram.chartOptions', {
      defaultMessage: 'Chart options'
    }),
    items: mainPanelItems
  }];
  if (!chart.hidden && !isPlainRecord) {
    panels.push({
      id: 1,
      initialFocusedItemIndex: selectedOptionIdx > -1 ? selectedOptionIdx : 0,
      title: _i18n.i18n.translate('unifiedHistogram.timeIntervals', {
        defaultMessage: 'Time intervals'
      }),
      items: _public.search.aggs.intervalOptions.filter(({
        val
      }) => val !== 'custom').map(({
        display,
        val
      }) => {
        return {
          name: display,
          label: display,
          icon: val === chart.timeInterval ? 'check' : 'empty',
          onClick: () => {
            onTimeIntervalChange === null || onTimeIntervalChange === void 0 ? void 0 : onTimeIntervalChange(val);
            closePopover();
          },
          'data-test-subj': `unifiedHistogramTimeInterval-${display}`,
          className: val === chart.timeInterval ? 'unifiedHistogramIntervalSelected' : ''
        };
      })
    });
  }
  return panels;
}