"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getResolvedDateRange = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Get resolved time range by using now provider
 * @param timefilter
 */
const getResolvedDateRange = timefilter => {
  const {
    from,
    to
  } = timefilter.getTime();
  const {
    min,
    max
  } = timefilter.calculateBounds({
    from,
    to
  });
  return {
    fromDate: (min === null || min === void 0 ? void 0 : min.toISOString()) || from,
    toDate: (max === null || max === void 0 ? void 0 : max.toISOString()) || to
  };
};
exports.getResolvedDateRange = getResolvedDateRange;