"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFieldFilters = useFieldFilters;
var _react = require("react");
var _eui = require("@elastic/eui");
var _field_types = require("../utils/field_types");
var _field_name_wildcard_matcher = require("../utils/field_name_wildcard_matcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const htmlId = (0, _eui.htmlIdGenerator)('fieldList');

/**
 * Input params for useFieldFilters hook
 */

/**
 * A hook for managing field search and filters state
 * @param allFields
 * @param getCustomFieldType
 * @param onSupportedFieldFilter
 * @param services
 * @public
 */
function useFieldFilters({
  allFields,
  getCustomFieldType,
  onSupportedFieldFilter,
  services
}) {
  const [selectedFieldTypes, setSelectedFieldTypes] = (0, _react.useState)([]);
  const [nameFilter, setNameFilter] = (0, _react.useState)('');
  const screenReaderDescriptionId = (0, _react.useMemo)(() => htmlId(), []);
  const docLinks = services.core.docLinks;
  return (0, _react.useMemo)(() => {
    const fieldSearchHighlight = nameFilter.toLowerCase();
    return {
      fieldSearchHighlight,
      fieldListFiltersProps: {
        docLinks,
        selectedFieldTypes,
        allFields,
        getCustomFieldType,
        onSupportedFieldFilter,
        onChangeFieldTypes: setSelectedFieldTypes,
        nameFilter,
        onChangeNameFilter: setNameFilter,
        screenReaderDescriptionId
      },
      onFilterField: fieldSearchHighlight !== null && fieldSearchHighlight !== void 0 && fieldSearchHighlight.length || selectedFieldTypes.length > 0 ? field => {
        if (fieldSearchHighlight && !(0, _field_name_wildcard_matcher.fieldNameWildcardMatcher)(field, fieldSearchHighlight)) {
          return false;
        }
        if (selectedFieldTypes.length > 0) {
          return selectedFieldTypes.includes((0, _field_types.getFieldIconType)(field, getCustomFieldType));
        }
        return true;
      } : undefined
    };
  }, [docLinks, selectedFieldTypes, allFields, getCustomFieldType, onSupportedFieldFilter, setSelectedFieldTypes, nameFilter, setNameFilter, screenReaderDescriptionId]);
}