"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldVisualizeButton = void 0;
exports.getFieldVisualizeButton = getFieldVisualizeButton;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _analytics = require("@kbn/analytics");
var _field_visualize_button_inner = require("./field_visualize_button_inner");
var _visualize_trigger_utils = require("./visualize_trigger_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldVisualizeButton = /*#__PURE__*/_react.default.memo(({
  field,
  dataView,
  contextualFields,
  trackUiMetric,
  multiFields,
  originatingApp,
  uiActions,
  buttonProps,
  visualizeInfo
}) => {
  if (!visualizeInfo) {
    return null;
  }
  const handleVisualizeLinkClick = async event => {
    // regular link click. let the uiActions code handle the navigation and show popup if needed
    event.preventDefault();
    const triggerVisualization = updatedDataView => {
      trackUiMetric === null || trackUiMetric === void 0 ? void 0 : trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'visualize_link_click');
      (0, _visualize_trigger_utils.triggerVisualizeActions)(uiActions, visualizeInfo.field, contextualFields, originatingApp, updatedDataView);
    };
    triggerVisualization(dataView);
  };
  return /*#__PURE__*/_react.default.createElement(_field_visualize_button_inner.FieldVisualizeButtonInner, {
    field: field,
    visualizeInfo: visualizeInfo,
    handleVisualizeLinkClick: handleVisualizeLinkClick,
    buttonProps: buttonProps
  });
});
exports.FieldVisualizeButton = FieldVisualizeButton;
async function getFieldVisualizeButton(props) {
  const visualizeInfo = await (0, _visualize_trigger_utils.getVisualizeInformation)(props.uiActions, props.field, props.dataView, props.contextualFields, props.multiFields);
  return visualizeInfo ? /*#__PURE__*/_react.default.createElement(FieldVisualizeButton, (0, _extends2.default)({}, props, {
    visualizeInfo: visualizeInfo
  })) : null;
}