"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProgressValue = exports.getOtherCount = exports.getFormattedPercentageValue = exports.getDefaultColor = exports.getBucketsValuesCount = exports.FieldTopValues = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _field_top_values_bucket = _interopRequireDefault(require("./field_top_values_bucket"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FieldTopValues = ({
  areExamples,
  buckets,
  dataView,
  field,
  sampledValuesCount,
  color = getDefaultColor(),
  'data-test-subj': dataTestSubject,
  onAddFilter,
  overrideFieldTopValueBar
}) => {
  if (!(buckets !== null && buckets !== void 0 && buckets.length)) {
    return null;
  }
  const formatter = dataView.getFormatterForField(field);
  const otherCount = getOtherCount(getBucketsValuesCount(buckets), sampledValuesCount);
  const digitsRequired = buckets.some(bucket => !Number.isInteger(bucket.count / sampledValuesCount));
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": areExamples ? 'unifiedFieldStats-exampleValueBuckets' : 'unifiedFieldStats-topValueBuckets'
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `${dataTestSubject}-topValues`
  }, buckets.map((bucket, index) => {
    const fieldValue = bucket.key;
    const formatted = formatter.convert(fieldValue);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: fieldValue
    }, index > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_field_top_values_bucket.default, {
      field: field,
      fieldValue: fieldValue,
      formattedFieldValue: formatted,
      formattedPercentage: getFormattedPercentageValue(bucket.count, sampledValuesCount, digitsRequired),
      progressValue: getProgressValue(bucket.count, sampledValuesCount),
      count: bucket.count,
      color: color,
      "data-test-subj": dataTestSubject,
      onAddFilter: onAddFilter,
      overrideFieldTopValueBar: overrideFieldTopValueBar
    }));
  }), otherCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_field_top_values_bucket.default, {
    type: "other",
    field: field,
    fieldValue: undefined,
    formattedPercentage: getFormattedPercentageValue(otherCount, sampledValuesCount, digitsRequired),
    progressValue: getProgressValue(otherCount, sampledValuesCount),
    count: otherCount,
    color: color,
    "data-test-subj": dataTestSubject,
    onAddFilter: onAddFilter,
    overrideFieldTopValueBar: overrideFieldTopValueBar
  }))));
};
exports.FieldTopValues = FieldTopValues;
const getDefaultColor = () => (0, _eui.euiPaletteColorBlind)()[1];
exports.getDefaultColor = getDefaultColor;
const getFormattedPercentageValue = (currentValue, totalCount, digitsRequired) => {
  return totalCount > 0 ? `${(Math.round(currentValue / totalCount * 1000) / 10).toFixed(digitsRequired ? 1 : 0)}%` : '';
};
exports.getFormattedPercentageValue = getFormattedPercentageValue;
const getProgressValue = (currentValue, totalCount) => {
  return totalCount > 0 ? currentValue / totalCount : 0;
};
exports.getProgressValue = getProgressValue;
const getBucketsValuesCount = buckets => {
  return (buckets === null || buckets === void 0 ? void 0 : buckets.reduce((prev, bucket) => bucket.count + prev, 0)) || 0;
};
exports.getBucketsValuesCount = getBucketsValuesCount;
const getOtherCount = (bucketsValuesCount, sampledValuesCount) => {
  return sampledValuesCount && bucketsValuesCount ? sampledValuesCount - bucketsValuesCount : 0;
};
exports.getOtherCount = getOtherCount;