"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTypeFilter = FieldTypeFilter;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _field_icon = require("../field_icon");
var _field_types = require("../../utils/field_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const EQUAL_HEIGHT_OFFSET = 2; // to avoid changes in the header's height after "Clear all" button appears
const popoverTitleStyle = (0, _react2.css)`
  padding: ${EQUAL_HEIGHT_OFFSET}px 0;
`;
const filterButtonStyle = (0, _react2.css)`
  .euiFilterButton__textShift {
    min-width: 0;
    line-height: 1;
  }
`;

/**
 * Props for FieldTypeFilter component
 */

/**
 * A popover with field type filters
 * @param dataTestSubject
 * @param docLinks
 * @param allFields
 * @param getCustomFieldType
 * @param selectedFieldTypes
 * @param onSupportedFieldFilter
 * @param onChange
 * @constructor
 */
function FieldTypeFilter({
  'data-test-subj': dataTestSubject,
  docLinks,
  allFields,
  getCustomFieldType,
  selectedFieldTypes,
  onSupportedFieldFilter,
  onChange
}) {
  const testSubj = `${dataTestSubject}FieldTypeFilter`;
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const [typeCounts, setTypeCounts] = (0, _react.useState)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const titleStyle = (0, _react.useMemo)(() => (0, _react2.css)`
      padding-top: calc(${euiTheme.size.m} - ${EQUAL_HEIGHT_OFFSET}px);
      padding-bottom: calc(${euiTheme.size.m} - ${EQUAL_HEIGHT_OFFSET}px);
      padding-left: ${euiTheme.size.m};
      padding-right: ${euiTheme.size.xs};
    `, [euiTheme.size.m, euiTheme.size.xs]);
  const itemStyle = (0, _react.useMemo)(() => (0, _react2.css)`
      font-size: ${euiTheme.size.m};
      padding: ${euiTheme.size.s} ${euiTheme.size.m};

      & + & {
        border-top: 1px solid ${euiTheme.colors.lightestShade};
      }
    `, [euiTheme]);
  (0, _react.useEffect)(() => {
    // calculate counts only if user opened the popover
    if (!isOpen || !(allFields !== null && allFields !== void 0 && allFields.length)) {
      setTypeCounts(undefined);
      return;
    }
    const counts = new Map();
    allFields.forEach(field => {
      if (onSupportedFieldFilter && !onSupportedFieldFilter(field)) {
        return;
      }
      const type = (0, _field_types.getFieldIconType)(field, getCustomFieldType);
      if ((0, _field_types.isKnownFieldType)(type)) {
        counts.set(type, (counts.get(type) || 0) + 1);
      }
    });
    setTypeCounts(counts);
  }, [isOpen, allFields, setTypeCounts, getCustomFieldType, onSupportedFieldFilter]);
  const availableFieldTypes = (0, _react.useMemo)(() => {
    // sorting is defined by items in KNOWN_FIELD_TYPE_LIST
    return _field_types.KNOWN_FIELD_TYPE_LIST.filter(type => {
      var _typeCounts$get;
      const knownTypeCount = (_typeCounts$get = typeCounts === null || typeCounts === void 0 ? void 0 : typeCounts.get(type)) !== null && _typeCounts$get !== void 0 ? _typeCounts$get : 0;
      // always include current field type filters - there may not be any fields of the type of an existing type filter on data view switch, but we still need to include the existing filter in the list so that the user can remove it
      return knownTypeCount > 0 || selectedFieldTypes.includes(type);
    });
  }, [typeCounts, selectedFieldTypes]);
  const clearAll = (0, _react.useCallback)(() => {
    onChange([]);
  }, [onChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "unifiedFieldTypeFilter",
    panelClassName: "euiFilterGroup__popoverPanel",
    panelPaddingSize: "none",
    anchorPosition: "rightUp",
    display: "block",
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "aria-label": _i18n.i18n.translate('unifiedFieldList.fieldTypeFilter.filterByTypeAriaLabel', {
        defaultMessage: 'Filter by type'
      }),
      color: "primary",
      isSelected: isOpen,
      numFilters: selectedFieldTypes.length,
      hasActiveFilters: !!selectedFieldTypes.length,
      numActiveFilters: selectedFieldTypes.length,
      "data-test-subj": `${testSubj}Toggle`,
      css: filterButtonStyle,
      onClick: () => setIsOpen(value => !value)
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "filter"
    }))
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    css: titleStyle,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: popoverTitleStyle
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    className: "eui-textBreakWord"
  }, _i18n.i18n.translate('unifiedFieldList.fieldTypeFilter.title', {
    defaultMessage: 'Filter by field type'
  })))), selectedFieldTypes.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: clearAll,
    "data-test-subj": `${testSubj}ClearAll`
  }, _i18n.i18n.translate('unifiedFieldList.fieldTypeFilter.clearAllLink', {
    defaultMessage: 'Clear all'
  }))))), availableFieldTypes.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": `${testSubj}Options`,
    items: availableFieldTypes.map(type => {
      var _typeCounts$get2;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: type,
        icon: selectedFieldTypes.includes(type) ? 'check' : 'empty',
        "data-test-subj": `typeFilter-${type}`,
        css: itemStyle,
        onClick: () => {
          onChange(selectedFieldTypes.includes(type) ? selectedFieldTypes.filter(t => t !== type) : [...selectedFieldTypes, type]);
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_field_icon.FieldIcon, {
        type: type
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, (0, _field_types.getFieldTypeName)(type))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "questionInCircle",
        color: "subdued",
        content: (0, _field_types.getFieldTypeDescription)(type)
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        color: "subdued",
        size: "m"
      }, (_typeCounts$get2 = typeCounts === null || typeCounts === void 0 ? void 0 : typeCounts.get(type)) !== null && _typeCounts$get2 !== void 0 ? _typeCounts$get2 : 0))));
    })
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "transparent",
    paddingSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('unifiedFieldList.fieldTypeFilter.learnMoreText', {
    defaultMessage: 'Learn more about'
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: docLinks.links.discover.fieldTypeHelp,
    target: "_blank",
    external: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "unifiedFieldList.fieldTypeFilter.fieldTypesDocLinkLabel",
    defaultMessage: "field types"
  }))))))));
}