"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldList = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const containerStyle = (0, _react2.css)`
  position: relative;
  width: 100%;
  height: 100%;
`;

/**
 * A top level wrapper props
 * @public
 */

/**
 * A top level wrapper for field list components (filters and field list groups)
 * @param dataTestSubject
 * @param isProcessing
 * @param prepend
 * @param append
 * @param className
 * @param children
 * @public
 * @constructor
 */
const FieldList = ({
  'data-test-subj': dataTestSubject = 'fieldList',
  isProcessing,
  prepend,
  append,
  className,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    responsive: false,
    "data-test-subj": dataTestSubject,
    css: containerStyle,
    className: className
  }, isProcessing && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }), !!prepend && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, prepend), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, children), !!append && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, append));
};
exports.FieldList = FieldList;