"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrilldownList = void 0;
var React = _interopRequireWildcard(require("react"));
var _drilldown_table = require("../../components/drilldown_table");
var _context = require("../context");
var _cloning_notification = require("./cloning_notification");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FIVE_SECONDS = 5e3;
const DrilldownList = ({}) => {
  const drilldowns = (0, _context.useDrilldownManager)();
  const events = drilldowns.useEvents();
  const cloningNotificationCount = React.useMemo(() => !!drilldowns.lastCloneRecord && drilldowns.lastCloneRecord.time > Date.now() - FIVE_SECONDS ? drilldowns.lastCloneRecord.templateIds.length : 0,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  React.useEffect(() => {
    drilldowns.lastCloneRecord = null;
  });
  const notification = !!cloningNotificationCount && /*#__PURE__*/React.createElement(_cloning_notification.CloningNotification, {
    count: cloningNotificationCount
  });
  return /*#__PURE__*/React.createElement(React.Fragment, null, notification, /*#__PURE__*/React.createElement(_drilldown_table.DrilldownTable, {
    items: events,
    onDelete: drilldowns.onDelete,
    onEdit: id => {
      drilldowns.setRoute(['manage', id]);
    },
    onCopy: drilldowns.onCreateFromDrilldown
  }));
};
exports.DrilldownList = DrilldownList;