"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.txtTriggerColumnTitle = exports.txtSourceColumnTitle = exports.txtSingleItemCopyActionLabel = exports.txtSelectableMessage = exports.txtNameColumnTitle = exports.txtCopyButtonLabel = exports.txtActionColumnTitle = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const txtSelectableMessage = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.selectableMessage', {
  defaultMessage: 'Select this template'
});
exports.txtSelectableMessage = txtSelectableMessage;
const txtNameColumnTitle = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.nameColumnTitle', {
  defaultMessage: 'Name',
  description: 'Title of the first column in drilldown template cloning table.'
});
exports.txtNameColumnTitle = txtNameColumnTitle;
const txtSourceColumnTitle = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.sourceColumnTitle', {
  defaultMessage: 'Panel',
  description: 'Column title which describes from where the drilldown is cloned.'
});
exports.txtSourceColumnTitle = txtSourceColumnTitle;
const txtActionColumnTitle = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.actionColumnTitle', {
  defaultMessage: 'Action'
});
exports.txtActionColumnTitle = txtActionColumnTitle;
const txtTriggerColumnTitle = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.triggerColumnTitle', {
  defaultMessage: 'Trigger'
});
exports.txtTriggerColumnTitle = txtTriggerColumnTitle;
const txtSingleItemCopyActionLabel = _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.singleItemCopyAction', {
  defaultMessage: 'Copy',
  description: '"Copy" action button label in drilldown template cloning table last column.'
});
exports.txtSingleItemCopyActionLabel = txtSingleItemCopyActionLabel;
const txtCopyButtonLabel = count => _i18n.i18n.translate('uiActionsEnhanced.components.DrilldownTemplateTable.copyButtonLabel', {
  defaultMessage: 'Copy ({count})',
  description: 'Label of drilldown template table bottom copy button.',
  values: {
    count
  }
});
exports.txtCopyButtonLabel = txtCopyButtonLabel;