"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _parse_duration = require("@kbn/alerting-plugin/common/parse_duration");
var _common = require("@kbn/alerting-plugin/common");
var _common2 = require("@kbn/actions-plugin/common");
var _get_time_options = require("../../../common/lib/get_time_options");
var _action_connector_form = require("../action_connector_form");
var _capabilities = require("../../lib/capabilities");
var _solution_filter = require("./solution_filter");
require("./rule_form.scss");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../constants");
var _check_rule_type_enabled = require("../../lib/check_rule_type_enabled");
var _rule_type_compare = require("../../lib/rule_type_compare");
var _constants2 = require("../../../common/constants");
var _section_loading = require("../../components/section_loading");
var _use_load_rule_types = require("../../hooks/use_load_rule_types");
var _get_initial_interval = require("./get_initial_interval");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTER_KEY = 13;
const INTEGER_REGEX = /^[1-9][0-9]*$/;
function getProducerFeatureName(producer, kibanaFeatures) {
  var _kibanaFeatures$find;
  return (_kibanaFeatures$find = kibanaFeatures.find(featureItem => featureItem.id === producer)) === null || _kibanaFeatures$find === void 0 ? void 0 : _kibanaFeatures$find.name;
}
const RuleForm = ({
  rule,
  config,
  canChangeTrigger = true,
  dispatch,
  errors,
  setHasActionsDisabled,
  setHasActionsWithBrokenConnector,
  operation,
  ruleTypeRegistry,
  actionTypeRegistry,
  metadata,
  filteredRuleTypes: ruleTypeToFilter,
  hideInterval,
  connectorFeatureId = _common2.AlertingConnectorFeatureId,
  onChangeMetaData
}) => {
  var _config$minimumSchedu, _selectedRuleType$rec, _rule$notifyWhen;
  const {
    notifications: {
      toasts
    },
    docLinks,
    application: {
      capabilities
    },
    kibanaFeatures,
    charts,
    data,
    unifiedSearch,
    dataViews
  } = (0, _kibana.useKibana)().services;
  const canShowActions = (0, _capabilities.hasShowActionsCapability)(capabilities);
  const [ruleTypeModel, setRuleTypeModel] = (0, _react.useState)(null);
  const defaultRuleInterval = (0, _get_initial_interval.getInitialInterval)((_config$minimumSchedu = config.minimumScheduleInterval) === null || _config$minimumSchedu === void 0 ? void 0 : _config$minimumSchedu.value);
  const defaultScheduleInterval = (0, _parse_duration.getDurationNumberInItsUnit)(defaultRuleInterval);
  const defaultScheduleIntervalUnit = (0, _parse_duration.getDurationUnitValue)(defaultRuleInterval);
  const [ruleInterval, setRuleInterval] = (0, _react.useState)(rule.schedule.interval ? (0, _parse_duration.getDurationNumberInItsUnit)(rule.schedule.interval) : defaultScheduleInterval);
  const [ruleIntervalUnit, setRuleIntervalUnit] = (0, _react.useState)(rule.schedule.interval ? (0, _parse_duration.getDurationUnitValue)(rule.schedule.interval) : defaultScheduleIntervalUnit);
  const [defaultActionGroupId, setDefaultActionGroupId] = (0, _react.useState)(undefined);
  const [availableRuleTypes, setAvailableRuleTypes] = (0, _react.useState)([]);
  const [filteredRuleTypes, setFilteredRuleTypes] = (0, _react.useState)([]);
  const [searchText, setSearchText] = (0, _react.useState)();
  const [inputText, setInputText] = (0, _react.useState)();
  const [solutions, setSolutions] = (0, _react.useState)(undefined);
  const [solutionsFilter, setSolutionFilter] = (0, _react.useState)([]);
  let hasDisabledByLicenseRuleTypes = false;
  const {
    ruleTypes,
    error: loadRuleTypesError,
    ruleTypeIndex,
    ruleTypesIsLoading
  } = (0, _use_load_rule_types.useLoadRuleTypes)({
    filteredRuleTypes: ruleTypeToFilter
  });

  // load rule types
  (0, _react.useEffect)(() => {
    if (rule.ruleTypeId && ruleTypeIndex !== null && ruleTypeIndex !== void 0 && ruleTypeIndex.has(rule.ruleTypeId)) {
      setDefaultActionGroupId(ruleTypeIndex.get(rule.ruleTypeId).defaultActionGroupId);
    }
    const getAvailableRuleTypes = ruleTypesResult => ruleTypeRegistry.list().reduce((arr, ruleTypeRegistryItem) => {
      const ruleType = ruleTypesResult.find(item => ruleTypeRegistryItem.id === item.id);
      if (ruleType) {
        arr.push({
          ruleType,
          ruleTypeModel: ruleTypeRegistryItem
        });
      }
      return arr;
    }, []).filter(item => item.ruleType && (0, _capabilities.hasAllPrivilege)(rule.consumer, item.ruleType)).filter(item => rule.consumer === _common.ALERTS_FEATURE_ID ? !item.ruleTypeModel.requiresAppContext : item.ruleType.producer === rule.consumer);
    const availableRuleTypesResult = getAvailableRuleTypes(ruleTypes);
    setAvailableRuleTypes(availableRuleTypesResult);
    const solutionsResult = availableRuleTypesResult.reduce((result, ruleTypeItem) => {
      if (!result.has(ruleTypeItem.ruleType.producer)) {
        var _ref;
        result.set(ruleTypeItem.ruleType.producer, (_ref = kibanaFeatures ? getProducerFeatureName(ruleTypeItem.ruleType.producer, kibanaFeatures) : (0, _lodash.capitalize)(ruleTypeItem.ruleType.producer)) !== null && _ref !== void 0 ? _ref : (0, _lodash.capitalize)(ruleTypeItem.ruleType.producer));
      }
      return result;
    }, new Map());
    setSolutions(new Map([...solutionsResult.entries()].sort(([, a], [, b]) => a.localeCompare(b))));
  }, [ruleTypes, ruleTypeIndex, rule.ruleTypeId, kibanaFeatures, rule.consumer, ruleTypeRegistry]);
  (0, _react.useEffect)(() => {
    if (loadRuleTypesError) {
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.unableToLoadRuleTypesMessage', {
          defaultMessage: 'Unable to load rule types'
        })
      });
    }
  }, [loadRuleTypesError, toasts]);
  (0, _react.useEffect)(() => {
    setRuleTypeModel(rule.ruleTypeId ? ruleTypeRegistry.get(rule.ruleTypeId) : null);
    if (rule.ruleTypeId && ruleTypeIndex && ruleTypeIndex.has(rule.ruleTypeId)) {
      setDefaultActionGroupId(ruleTypeIndex.get(rule.ruleTypeId).defaultActionGroupId);
    }
  }, [rule, rule.ruleTypeId, ruleTypeIndex, ruleTypeRegistry]);
  (0, _react.useEffect)(() => {
    if (rule.schedule.interval) {
      const interval = (0, _parse_duration.getDurationNumberInItsUnit)(rule.schedule.interval);
      const intervalUnit = (0, _parse_duration.getDurationUnitValue)(rule.schedule.interval);
      setRuleInterval(interval);
      setRuleIntervalUnit(intervalUnit);
    }
  }, [rule.schedule.interval, defaultScheduleInterval, defaultScheduleIntervalUnit]);
  const setRuleProperty = (0, _react.useCallback)((key, value) => {
    dispatch({
      command: {
        type: 'setProperty'
      },
      payload: {
        key,
        value
      }
    });
  }, [dispatch]);
  const setActions = (0, _react.useCallback)(updatedActions => setRuleProperty('actions', updatedActions), [setRuleProperty]);
  const setRuleParams = (key, value) => {
    dispatch({
      command: {
        type: 'setRuleParams'
      },
      payload: {
        key,
        value
      }
    });
  };
  const setScheduleProperty = (key, value) => {
    dispatch({
      command: {
        type: 'setScheduleProperty'
      },
      payload: {
        key,
        value
      }
    });
  };
  const setActionProperty = (key, value, index) => {
    dispatch({
      command: {
        type: 'setRuleActionProperty'
      },
      payload: {
        key,
        value,
        index
      }
    });
  };
  const setActionParamsProperty = (0, _react.useCallback)((key, value, index) => {
    dispatch({
      command: {
        type: 'setRuleActionParams'
      },
      payload: {
        key,
        value,
        index
      }
    });
  }, [dispatch]);
  const setActionFrequencyProperty = (0, _react.useCallback)((key, value, index) => {
    dispatch({
      command: {
        type: 'setRuleActionFrequency'
      },
      payload: {
        key,
        value,
        index
      }
    });
  }, [dispatch]);
  const setActionAlertsFilterProperty = (0, _react.useCallback)((key, value, index) => {
    dispatch({
      command: {
        type: 'setRuleActionAlertsFilter'
      },
      payload: {
        key,
        value,
        index
      }
    });
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    const searchValue = searchText ? searchText.trim().toLocaleLowerCase() : null;
    setFilteredRuleTypes(availableRuleTypes.filter(ruleTypeItem => solutionsFilter.length > 0 ? solutionsFilter.find(item => ruleTypeItem.ruleType.producer === item) : ruleTypeItem).filter(ruleTypeItem => searchValue ? ruleTypeItem.ruleType.name.toString().toLocaleLowerCase().includes(searchValue) || ruleTypeItem.ruleType.producer.toLocaleLowerCase().includes(searchValue) || ruleTypeItem.ruleTypeModel.description.toLocaleLowerCase().includes(searchValue) : ruleTypeItem));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ruleTypeRegistry, availableRuleTypes, searchText, JSON.stringify(solutionsFilter)]);
  const selectedRuleType = rule !== null && rule !== void 0 && rule.ruleTypeId ? ruleTypeIndex === null || ruleTypeIndex === void 0 ? void 0 : ruleTypeIndex.get(rule === null || rule === void 0 ? void 0 : rule.ruleTypeId) : undefined;
  const recoveryActionGroup = selectedRuleType === null || selectedRuleType === void 0 ? void 0 : (_selectedRuleType$rec = selectedRuleType.recoveryActionGroup) === null || _selectedRuleType$rec === void 0 ? void 0 : _selectedRuleType$rec.id;
  const tagsOptions = rule.tags ? rule.tags.map(label => ({
    label
  })) : [];
  const isActionGroupDisabledForActionType = (0, _react.useCallback)((ruleType, actionGroupId, actionTypeId) => {
    var _ruleType$recoveryAct;
    return (0, _common.isActionGroupDisabledForActionTypeId)(actionGroupId === (ruleType === null || ruleType === void 0 ? void 0 : (_ruleType$recoveryAct = ruleType.recoveryActionGroup) === null || _ruleType$recoveryAct === void 0 ? void 0 : _ruleType$recoveryAct.id) ? _common.RecoveredActionGroup.id : actionGroupId, actionTypeId);
  }, []);
  const RuleParamsExpressionComponent = ruleTypeModel ? ruleTypeModel.ruleParamsExpression : null;
  const ruleTypesByProducer = filteredRuleTypes.reduce((result, ruleTypeValue) => {
    const producer = ruleTypeValue.ruleType.producer;
    if (producer) {
      const checkEnabledResult = (0, _check_rule_type_enabled.checkRuleTypeEnabled)(ruleTypeValue.ruleType);
      if (!checkEnabledResult.isEnabled) {
        hasDisabledByLicenseRuleTypes = true;
      }
      (result[producer] = result[producer] || []).push({
        name: ruleTypeValue.ruleType.name,
        id: ruleTypeValue.ruleTypeModel.id,
        checkEnabledResult,
        ruleTypeItem: ruleTypeValue.ruleTypeModel
      });
    }
    return result;
  }, {});
  const ruleTypeNodes = Object.entries(ruleTypesByProducer).sort((a, b) => (0, _rule_type_compare.ruleTypeGroupCompare)(a, b, solutions)).map(([solution, items], groupIndex) => {
    var _ref2;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: `group${groupIndex}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "center",
      className: "triggersActionsUI__ruleTypeNodeHeading"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      "data-test-subj": `ruleType${groupIndex}Group`,
      size: "xxxs",
      textTransform: "uppercase"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, (_ref2 = kibanaFeatures ? getProducerFeatureName(solution, kibanaFeatures) : (0, _lodash.capitalize)(solution)) !== null && _ref2 !== void 0 ? _ref2 : (0, _lodash.capitalize)(solution)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      color: "subdued"
    }, items.length))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      size: "full",
      margin: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
      flush: true,
      gutterSize: "m",
      size: "m",
      maxWidth: false
    }, items.sort((a, b) => (0, _rule_type_compare.ruleTypeCompare)(a, b)).map((item, index) => {
      const ruleTypeListItemHtml = /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("strong", null, item.name), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("p", null, item.ruleTypeItem.description)));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
        wrapText: true,
        key: index,
        "data-test-subj": `${item.id}-SelectOption`,
        color: "primary",
        label: item.checkEnabledResult.isEnabled ? ruleTypeListItemHtml : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          position: "top",
          "data-test-subj": `${item.id}-disabledTooltip`,
          content: item.checkEnabledResult.message
        }, ruleTypeListItemHtml),
        isDisabled: !item.checkEnabledResult.isEnabled,
        onClick: () => {
          setRuleProperty('ruleTypeId', item.id);
          setRuleTypeModel(item.ruleTypeItem);
          setActions([]);
          setRuleProperty('params', {});
          if (ruleTypeIndex && ruleTypeIndex.has(item.id)) {
            setDefaultActionGroupId(ruleTypeIndex.get(item.id).defaultActionGroupId);
          }
        }
      });
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
  });
  const labelForRuleChecked = [_i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.checkFieldLabel', {
    defaultMessage: 'Check every'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "right",
    type: "questionInCircle",
    content: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.checkWithTooltip', {
      defaultMessage: 'Define how often to evaluate the condition. Checks are queued; they run as close to the defined value as capacity allows.'
    })
  })];
  const getHelpTextForInterval = () => {
    if (!config || !config.minimumScheduleInterval) {
      return '';
    }

    // No help text if there is an error
    if (errors['schedule.interval'].length > 0) {
      return '';
    }
    if (config.minimumScheduleInterval.enforce) {
      // Always show help text if minimum is enforced
      return _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.checkEveryHelpText', {
        defaultMessage: 'Interval must be at least {minimum}.',
        values: {
          minimum: (0, _parse_duration.formatDuration)(config.minimumScheduleInterval.value, true)
        }
      });
    } else if (rule.schedule.interval && (0, _parse_duration.parseDuration)(rule.schedule.interval) < (0, _parse_duration.parseDuration)(config.minimumScheduleInterval.value)) {
      // Only show help text if current interval is less than suggested
      return _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.checkEveryHelpSuggestionText', {
        defaultMessage: 'Intervals less than {minimum} are not recommended due to performance considerations.',
        values: {
          minimum: (0, _parse_duration.formatDuration)(config.minimumScheduleInterval.value, true)
        }
      });
    } else {
      return '';
    }
  };
  const ruleTypeDetails = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "selectedRuleTypeTitle"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    id: "selectedRuleTypeTitle"
  }, rule.ruleTypeId && ruleTypeIndex && ruleTypeIndex.has(rule.ruleTypeId) ? ruleTypeIndex.get(rule.ruleTypeId).name : ''))), canChangeTrigger ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    color: "danger",
    "aria-label": _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.changeRuleTypeAriaLabel', {
      defaultMessage: 'Delete'
    }),
    onClick: () => {
      setRuleProperty('ruleTypeId', null);
      setRuleTypeModel(null);
      setRuleProperty('params', {});
    }
  })) : null), (ruleTypeModel === null || ruleTypeModel === void 0 ? void 0 : ruleTypeModel.description) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    "data-test-subj": "ruleDescription"
  }, ruleTypeModel.description, "\xA0", (ruleTypeModel === null || ruleTypeModel === void 0 ? void 0 : ruleTypeModel.documentationUrl) && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    external: true,
    target: "_blank",
    "data-test-subj": "ruleDocumentationLink",
    href: typeof ruleTypeModel.documentationUrl === 'function' ? ruleTypeModel.documentationUrl(docLinks) : ruleTypeModel.documentationUrl
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleForm.documentationLabel",
    defaultMessage: "Learn more"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), RuleParamsExpressionComponent && defaultActionGroupId && rule.ruleTypeId && selectedRuleType ? /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_section_loading.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.ruleForm.loadingRuleTypeParamsDescription",
      defaultMessage: "Loading rule type params\u2026"
    }))
  }, /*#__PURE__*/_react.default.createElement(RuleParamsExpressionComponent, {
    ruleParams: rule.params,
    ruleInterval: `${ruleInterval !== null && ruleInterval !== void 0 ? ruleInterval : 1}${ruleIntervalUnit}`,
    ruleThrottle: '',
    alertNotifyWhen: (_rule$notifyWhen = rule.notifyWhen) !== null && _rule$notifyWhen !== void 0 ? _rule$notifyWhen : 'onActionGroupChange',
    errors: errors,
    setRuleParams: setRuleParams,
    setRuleProperty: setRuleProperty,
    defaultActionGroupId: defaultActionGroupId,
    actionGroups: selectedRuleType.actionGroups,
    metadata: metadata,
    charts: charts,
    data: data,
    dataViews: dataViews,
    unifiedSearch: unifiedSearch,
    onChangeMetaData: onChangeMetaData
  }))) : null, hideInterval !== true && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    "data-test-subj": "intervalFormRow",
    display: "rowCompressed",
    helpText: getHelpTextForInterval(),
    isInvalid: errors['schedule.interval'].length > 0,
    error: errors['schedule.interval']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    prepend: labelForRuleChecked,
    fullWidth: true,
    min: 1,
    isInvalid: errors['schedule.interval'].length > 0,
    value: ruleInterval || '',
    name: "interval",
    "data-test-subj": "intervalInput",
    onChange: e => {
      const value = e.target.value;
      if (value === '' || INTEGER_REGEX.test(value)) {
        const parsedValue = value === '' ? '' : parseInt(value, 10);
        setRuleInterval(parsedValue || undefined);
        setScheduleProperty('interval', `${parsedValue}${ruleIntervalUnit}`);
      }
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    value: ruleIntervalUnit,
    options: (0, _get_time_options.getTimeOptions)(ruleInterval !== null && ruleInterval !== void 0 ? ruleInterval : 1),
    onChange: e => {
      setRuleIntervalUnit(e.target.value);
      setScheduleProperty('interval', `${ruleInterval}${e.target.value}`);
    },
    "data-test-subj": "intervalInputUnit"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), canShowActions && defaultActionGroupId && ruleTypeModel && rule.ruleTypeId && selectedRuleType ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errors.actionConnectors.length >= 1 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    size: "s",
    title: errors.actionConnectors
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_action_connector_form.ActionForm, {
    actions: rule.actions,
    setHasActionsDisabled: setHasActionsDisabled,
    setHasActionsWithBrokenConnector: setHasActionsWithBrokenConnector,
    messageVariables: selectedRuleType.actionVariables,
    defaultActionGroupId: defaultActionGroupId,
    hasSummary: selectedRuleType.hasGetSummarizedAlerts,
    featureId: connectorFeatureId,
    producerId: selectedRuleType.producer,
    hasFieldsForAAD: selectedRuleType.hasFieldsForAAD,
    ruleTypeId: rule.ruleTypeId,
    isActionGroupDisabledForActionType: (actionGroupId, actionTypeId) => isActionGroupDisabledForActionType(selectedRuleType, actionGroupId, actionTypeId),
    actionGroups: selectedRuleType.actionGroups.map(actionGroup => actionGroup.id === selectedRuleType.recoveryActionGroup.id ? {
      ...actionGroup,
      omitMessageVariables: selectedRuleType.doesSetRecoveryContext ? 'keepContext' : 'all',
      defaultActionMessage: (ruleTypeModel === null || ruleTypeModel === void 0 ? void 0 : ruleTypeModel.defaultRecoveryMessage) || _constants.recoveredActionGroupMessage
    } : {
      ...actionGroup,
      defaultActionMessage: ruleTypeModel === null || ruleTypeModel === void 0 ? void 0 : ruleTypeModel.defaultActionMessage
    }),
    recoveryActionGroup: recoveryActionGroup,
    setActionIdByIndex: (id, index) => setActionProperty('id', id, index),
    setActionGroupIdByIndex: (group, index) => setActionProperty('group', group, index),
    setActions: setActions,
    setActionParamsProperty: setActionParamsProperty,
    actionTypeRegistry: actionTypeRegistry,
    setActionFrequencyProperty: setActionFrequencyProperty,
    setActionAlertsFilterProperty: setActionAlertsFilterProperty,
    defaultSummaryMessage: (ruleTypeModel === null || ruleTypeModel === void 0 ? void 0 : ruleTypeModel.defaultSummaryMessage) || _constants.summaryMessage,
    minimumThrottleInterval: [ruleInterval, ruleIntervalUnit]
  })) : null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    id: "ruleName",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.ruleForm.ruleNameLabel",
      defaultMessage: "Name"
    }),
    isInvalid: errors.name.length > 0 && rule.name !== undefined,
    error: errors.name
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    autoFocus: true,
    isInvalid: errors.name.length > 0 && rule.name !== undefined,
    name: "name",
    "data-test-subj": "ruleNameInput",
    value: rule.name || '',
    onChange: e => {
      setRuleProperty('name', e.target.value);
    },
    onBlur: () => {
      if (!rule.name) {
        setRuleProperty('name', '');
      }
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.tagsFieldLabel', {
      defaultMessage: 'Tags (optional)'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    fullWidth: true,
    "data-test-subj": "tagsComboBox",
    selectedOptions: tagsOptions,
    onCreateOption: searchValue => {
      const newOptions = [...tagsOptions, {
        label: searchValue
      }];
      setRuleProperty('tags', newOptions.map(newOption => newOption.label));
    },
    onChange: selectedOptions => {
      setRuleProperty('tags', selectedOptions.map(selectedOption => selectedOption.label));
    },
    onBlur: () => {
      if (!rule.tags) {
        setRuleProperty('tags', []);
      }
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), ruleTypeModel ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ruleTypeDetails) : availableRuleTypes.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    labelAppend: hasDisabledByLicenseRuleTypes && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: _constants2.VIEW_LICENSE_OPTIONS_LINK,
      target: "_blank",
      external: true,
      className: "actActionForm__getMoreActionsLink"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Get more rule types",
      id: "xpack.triggersActionsUI.sections.actionForm.getMoreRuleTypesTitle"
    }))),
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.ruleForm.ruleTypeSelectLabel",
      defaultMessage: "Select rule type"
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    fullWidth: true,
    "data-test-subj": "ruleSearchField",
    onChange: e => {
      setInputText(e.target.value);
      if (e.target.value === '') {
        setSearchText('');
      }
    },
    onKeyUp: e => {
      if (e.keyCode === ENTER_KEY) {
        setSearchText(inputText);
      }
    },
    placeholder: _i18n.i18n.translate('xpack.triggersActionsUI.sections.ruleForm.searchPlaceholderTitle', {
      defaultMessage: 'Search'
    })
  })), solutions ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_solution_filter.SolutionFilter, {
    key: "solution-filter",
    solutions: solutions,
    onChange: selectedSolutions => setSolutionFilter(selectedSolutions)
  })) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), errors.ruleTypeId.length >= 1 && rule.ruleTypeId !== undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    size: "s",
    title: errors.ruleTypeId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, ruleTypeNodes) : ruleTypeIndex && !ruleTypesIsLoading ? /*#__PURE__*/_react.default.createElement(NoAuthorizedRuleTypes, {
    operation: operation
  }) : /*#__PURE__*/_react.default.createElement(_section_loading.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleForm.loadingRuleTypesDescription",
    defaultMessage: "Loading rule types\u2026"
  })));
};
exports.RuleForm = RuleForm;
const NoAuthorizedRuleTypes = ({
  operation
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "lock",
  "data-test-subj": "noAuthorizedRuleTypesPrompt",
  titleSize: "xs",
  title: /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleForm.error.noAuthorizedRuleTypesTitle",
    defaultMessage: "You have not been authorized to {operation} any rule types",
    values: {
      operation
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", {
    role: "banner"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.ruleForm.error.noAuthorizedRuleTypes",
    defaultMessage: "In order to {operation} a Rule you need to have been granted the appropriate privileges.",
    values: {
      operation
    }
  })))
});