"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTableHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../translations"));
var _field_table_header = require("./field_table_header.styles");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldTableHeaderComponent = ({
  fieldCount,
  filterSelectedEnabled,
  onFilterSelectedChange
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(open => !open);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setIsPopoverOpen(false);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "fields-showing",
    size: "xs"
  }, i18n.FIELDS_SHOWING, /*#__PURE__*/_react.default.createElement("span", {
    css: _field_table_header.styles.count,
    "data-test-subj": "fields-count"
  }, ' ', fieldCount, ' '), i18n.FIELDS_COUNT(fieldCount))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    anchorPosition: "downRight",
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "viewSelectorButton",
      size: "xs",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: togglePopover
    }, `${i18n.VIEW_LABEL}: ${filterSelectedEnabled ? i18n.VIEW_VALUE_SELECTED : i18n.VIEW_VALUE_ALL}`)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "viewSelectorMenu",
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "viewSelectorOption-all",
      key: "viewAll",
      icon: filterSelectedEnabled ? 'empty' : 'check',
      onClick: () => {
        onFilterSelectedChange(false);
        closePopover();
      }
    }, `${i18n.VIEW_LABEL} ${i18n.VIEW_VALUE_ALL}`), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      key: "separator",
      margin: "none"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "viewSelectorOption-selected",
      key: "viewSelected",
      icon: filterSelectedEnabled ? 'check' : 'empty',
      onClick: () => {
        onFilterSelectedChange(true);
        closePopover();
      }
    }, `${i18n.VIEW_LABEL} ${i18n.VIEW_VALUE_SELECTED}`)]
  }))));
};
const FieldTableHeader = /*#__PURE__*/_react.default.memo(FieldTableHeaderComponent);
exports.FieldTableHeader = FieldTableHeader;