"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkGetMaintenanceWindows = void 0;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../../../common/lib/kibana");
var _use_license = require("../../../hooks/use_license");
var _constants = require("../../../hooks/constants");
var _bulk_get_maintenance_windows = require("./apis/bulk_get_maintenance_windows");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ERROR_TITLE = _i18n.i18n.translate('xpack.triggersActionsUI.alertsTable.api.bulkGetMaintenanceWindow.errorTitle', {
  defaultMessage: 'Error fetching maintenance windows data'
});
const transformMaintenanceWindows = data => {
  const maintenanceWindowsMap = new Map();
  for (const maintenanceWindow of (_data$maintenanceWind = data === null || data === void 0 ? void 0 : data.maintenanceWindows) !== null && _data$maintenanceWind !== void 0 ? _data$maintenanceWind : []) {
    var _data$maintenanceWind;
    maintenanceWindowsMap.set(maintenanceWindow.id, {
      ...maintenanceWindow
    });
  }
  return maintenanceWindowsMap;
};
const useBulkGetMaintenanceWindows = props => {
  const {
    ids,
    canFetchMaintenanceWindows = false
  } = props;
  const {
    http,
    notifications: {
      toasts
    },
    application: {
      capabilities: {
        maintenanceWindow: {
          show
        }
      }
    }
  } = (0, _kibana.useKibana)().services;
  const {
    isAtLeastPlatinum
  } = (0, _use_license.useLicense)();
  const hasLicense = isAtLeastPlatinum();
  const queryFn = () => {
    return (0, _bulk_get_maintenance_windows.bulkGetMaintenanceWindows)({
      http,
      ids
    });
  };
  const onError = error => {
    toasts.addError(error.body && error.body.message ? new Error(error.body.message) : error, {
      title: ERROR_TITLE
    });
  };
  const {
    data,
    isFetching
  } = (0, _reactQuery.useQuery)({
    queryKey: _constants.triggersActionsUiQueriesKeys.maintenanceWindowsBulkGet(ids),
    enabled: hasLicense && show && ids.length > 0 && canFetchMaintenanceWindows,
    select: transformMaintenanceWindows,
    queryFn,
    onError
  });
  return {
    data,
    isFetching
  };
};
exports.useBulkGetMaintenanceWindows = useBulkGetMaintenanceWindows;