"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkActionsReducer = void 0;
var _types = require("../../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAllRowsInPage = rowCount => new Map(Array.from(Array(rowCount).keys()).map(idx => [idx, {
  isLoading: false
}]));
const bulkActionsReducer = (currentState, {
  action,
  rowIndex,
  rowCount,
  isLoading = false
}) => {
  const {
    rowSelection,
    rowCount: currentRowCount
  } = currentState;
  const nextState = {
    ...currentState
  };
  if (action === _types.BulkActionsVerbs.add && rowIndex !== undefined) {
    const nextRowSelection = new Map(rowSelection);
    nextRowSelection.set(rowIndex, {
      isLoading
    });
    nextState.rowSelection = nextRowSelection;
  } else if (action === _types.BulkActionsVerbs.delete && rowIndex !== undefined) {
    const nextRowSelection = new Map(rowSelection);
    nextRowSelection.delete(rowIndex);
    nextState.rowSelection = nextRowSelection;
  } else if (action === _types.BulkActionsVerbs.selectCurrentPage) {
    nextState.rowSelection = getAllRowsInPage(currentRowCount);
  } else if (action === _types.BulkActionsVerbs.selectAll) {
    nextState.rowSelection = getAllRowsInPage(currentRowCount);
    nextState.isAllSelected = true;
  } else if (action === _types.BulkActionsVerbs.clear) {
    nextState.rowSelection = new Map();
    nextState.isAllSelected = false;
  } else if (action === _types.BulkActionsVerbs.rowCountUpdate && rowCount !== undefined) {
    nextState.rowCount = rowCount;
  } else if (action === _types.BulkActionsVerbs.updateAllLoadingState) {
    const nextRowSelection = new Map(Array.from(rowSelection.keys()).map(idx => [idx, {
      isLoading
    }]));
    nextState.rowSelection = nextRowSelection;
  } else if (action === _types.BulkActionsVerbs.updateRowLoadingState && rowIndex !== undefined) {
    nextState.rowSelection.set(rowIndex, {
      isLoading
    });
  }
  nextState.areAllVisibleRowsSelected = nextState.rowSelection.size === nextState.rowCount;
  return nextState;
};
exports.bulkActionsReducer = bulkActionsReducer;