"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ActionsConnectorsHome = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../constants");
var _breadcrumb = require("../../../lib/breadcrumb");
var _doc_title = require("../../../lib/doc_title");
var _suspended_component_with_props = require("../../../lib/suspended_component_with_props");
var _health_context = require("../../../context/health_context");
var _health_check = require("../../../components/health_check");
var _kibana = require("../../../../common/lib/kibana");
var _actions_connectors_event_log_list_table = _interopRequireDefault(require("./actions_connectors_event_log_list_table"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const ConnectorsList = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./actions_connectors_list'))));
const ActionsConnectorsHome = ({
  match: {
    params: {
      section
    }
  },
  history
}) => {
  const {
    chrome,
    setBreadcrumbs,
    docLinks
  } = (0, _kibana.useKibana)().services;
  const tabs = [];
  tabs.push({
    id: 'connectors',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.connectors.home.connectorsTabTitle",
      defaultMessage: "Connectors"
    })
  });
  tabs.push({
    id: 'logs',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.connectors.home.logsTabTitle",
      defaultMessage: "Logs"
    })
  });
  const onSectionChange = newSection => {
    history.push(`/${newSection}`);
  };

  // Set breadcrumb and page title
  (0, _react.useEffect)(() => {
    setBreadcrumbs([(0, _breadcrumb.getAlertingSectionBreadcrumb)(section || 'connectors')]);
    chrome.docTitle.change((0, _doc_title.getCurrentDocTitle)(section || 'connectors'));
  }, [section, chrome, setBreadcrumbs]);
  const renderLogsList = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
      grow: false,
      paddingSize: "none"
    }, (0, _suspended_component_with_props.suspendedComponentWithProps)(_actions_connectors_event_log_list_table.default, 'xl')({
      refreshToken: 0,
      initialPageSize: 50,
      hasConnectorNames: true,
      hasAllSpaceSwitch: true
    }));
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    paddingSize: "none",
    pageTitle: _i18n.i18n.translate('xpack.triggersActionsUI.connectors.home.appTitle', {
      defaultMessage: 'Connectors'
    }),
    description: _i18n.i18n.translate('xpack.triggersActionsUI.connectors.home.description', {
      defaultMessage: 'Connect third-party software with your alerting data.'
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "documentationButton",
      key: "documentation-button",
      href: docLinks.links.alerting.actionTypes,
      iconType: "help"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.connectors.home.documentationButtonLabel",
      defaultMessage: "Documentation"
    }))],
    tabs: tabs.map(tab => ({
      label: tab.name,
      onClick: () => onSectionChange(tab.id),
      isSelected: tab.id === section,
      key: tab.id,
      'data-test-subj': `${tab.id}Tab`
    }))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_health_context.HealthContextProvider, null, /*#__PURE__*/_react.default.createElement(_health_check.HealthCheck, {
    waitForCheck: true
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.routeToLogs,
    component: renderLogsList
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _constants.routeToConnectors,
    component: (0, _suspended_component_with_props.suspendedComponentWithProps)(ConnectorsList, 'xl')
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.ActionsConnectorsHome = ActionsConnectorsHome;