"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.CreateConnectorFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/actions-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _capabilities = require("../../../lib/capabilities");
var _kibana = require("../../../../common/lib/kibana");
var _action_type_menu = require("../action_type_menu");
var _use_create_connector = require("../../../hooks/use_create_connector");
var _connector_form = require("../connector_form");
var _header = require("./header");
var _footer = require("./footer");
var _upgrade_license_callout = require("./upgrade_license_callout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateConnectorFlyoutComponent = ({
  actionTypeRegistry,
  featureId,
  onClose,
  onConnectorCreated,
  onTestConnector
}) => {
  var _actionType$id, _actionTypeModel$subt;
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    isLoading: isSavingConnector,
    createConnector
  } = (0, _use_create_connector.useCreateConnector)();
  const isMounted = (0, _react.useRef)(false);
  const [allActionTypes, setAllActionTypes] = (0, _react.useState)(undefined);
  const [actionType, setActionType] = (0, _react.useState)(null);
  const [hasActionsUpgradeableByTrial, setHasActionsUpgradeableByTrial] = (0, _react.useState)(false);
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const [preSubmitValidationErrorMessage, setPreSubmitValidationErrorMessage] = (0, _react.useState)(null);
  const [formState, setFormState] = (0, _react.useState)({
    isSubmitted: false,
    isSubmitting: false,
    isValid: undefined,
    submit: async () => ({
      isValid: false,
      data: {}
    }),
    preSubmitValidator: null
  });
  const initialConnector = {
    actionTypeId: (_actionType$id = actionType === null || actionType === void 0 ? void 0 : actionType.id) !== null && _actionType$id !== void 0 ? _actionType$id : '',
    isDeprecated: false,
    config: {},
    secrets: {},
    isMissingSecrets: false
  };
  const {
    preSubmitValidator,
    submit,
    isValid: isFormValid,
    isSubmitting
  } = formState;
  const hasErrors = isFormValid === false;
  const isSaving = isSavingConnector || isSubmitting;
  const hasConnectorTypeSelected = actionType != null;
  const actionTypeModel = actionType != null ? actionTypeRegistry.get(actionType.id) : null;

  /* Future Developer
   * We are excluding `UptimeConnectorFeatureId` because as this time Synthetics won't work
   * with slack API on their UI, We need to add an ISSUE here so they can fix it
   */
  const groupActionTypeModel = actionTypeModel && actionTypeModel.subtype && featureId !== _common.UptimeConnectorFeatureId ? ((_actionTypeModel$subt = actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.subtype) !== null && _actionTypeModel$subt !== void 0 ? _actionTypeModel$subt : []).map(subtypeAction => ({
    ...actionTypeRegistry.get(subtypeAction.id),
    name: subtypeAction.name
  })) : [];
  const groupActionButtons = groupActionTypeModel.map(gAction => ({
    id: gAction.id,
    label: gAction.name,
    'data-test-subj': `${gAction.id}Button`
  }));
  const resetConnectorForm = (0, _react.useRef)();
  const setResetForm = reset => {
    resetConnectorForm.current = reset;
  };
  const onChangeGroupAction = id => {
    if (allActionTypes && allActionTypes[id]) {
      setActionType(allActionTypes[id]);
      if (resetConnectorForm.current) {
        resetConnectorForm.current({
          resetValues: true,
          defaultValue: {
            actionTypeId: id,
            isDeprecated: false,
            config: {},
            secrets: {}
          }
        });
      }
    }
  };
  const validateAndCreateConnector = (0, _react.useCallback)(async () => {
    setPreSubmitValidationErrorMessage(null);
    const {
      isValid,
      data
    } = await submit();
    if (!isMounted.current) {
      // User has closed the flyout meanwhile submitting the form
      return;
    }
    if (isValid) {
      if (preSubmitValidator) {
        const validatorRes = await preSubmitValidator();
        if (validatorRes) {
          setPreSubmitValidationErrorMessage(validatorRes.message);
          return;
        }
      }

      /**
       * At this point the form is valid
       * and there are no pre submit error messages.
       */

      const {
        actionTypeId,
        name,
        config,
        secrets
      } = data;
      const validConnector = {
        actionTypeId,
        name: name !== null && name !== void 0 ? name : '',
        config: config !== null && config !== void 0 ? config : {},
        secrets: secrets !== null && secrets !== void 0 ? secrets : {}
      };
      const createdConnector = await createConnector(validConnector);
      return createdConnector;
    }
  }, [submit, preSubmitValidator, createConnector]);
  const resetActionType = (0, _react.useCallback)(() => setActionType(null), []);
  const testConnector = (0, _react.useCallback)(async () => {
    const createdConnector = await validateAndCreateConnector();
    if (createdConnector) {
      if (onConnectorCreated) {
        onConnectorCreated(createdConnector);
      }
      if (onTestConnector) {
        onTestConnector(createdConnector);
      }
      onClose();
    }
  }, [validateAndCreateConnector, onClose, onConnectorCreated, onTestConnector]);
  const onSubmit = (0, _react.useCallback)(async () => {
    const createdConnector = await validateAndCreateConnector();
    if (createdConnector) {
      if (onConnectorCreated) {
        onConnectorCreated(createdConnector);
      }
      onClose();
    }
  }, [validateAndCreateConnector, onClose, onConnectorCreated]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "create-connector-flyout"
  }, /*#__PURE__*/_react.default.createElement(_header.FlyoutHeader, {
    icon: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.iconClass,
    actionTypeName: actionType === null || actionType === void 0 ? void 0 : actionType.name,
    actionTypeMessage: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.selectMessage,
    compatibility: (0, _common.getConnectorCompatibility)(actionType === null || actionType === void 0 ? void 0 : actionType.supportedFeatureIds),
    isExperimental: actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.isExperimental
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: !actionType && hasActionsUpgradeableByTrial ? /*#__PURE__*/_react.default.createElement(_upgrade_license_callout.UpgradeLicenseCallOut, null) : null
  }, hasConnectorTypeSelected ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groupActionTypeModel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    isFullWidth: true,
    buttonSize: "m",
    color: "primary",
    legend: "",
    options: groupActionButtons,
    idSelected: actionType.id,
    onChange: onChangeGroupAction,
    "data-test-subj": "slackTypeChangeButton"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  })), /*#__PURE__*/_react.default.createElement(_connector_form.ConnectorForm, {
    actionTypeModel: actionTypeModel,
    connector: initialConnector,
    isEdit: false,
    onChange: setFormState,
    setResetForm: setResetForm
  }), !!preSubmitValidationErrorMessage && /*#__PURE__*/_react.default.createElement("p", null, preSubmitValidationErrorMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, onTestConnector && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    "data-test-subj": "create-connector-flyout-save-test-btn",
    type: "submit",
    isLoading: isSaving,
    disabled: hasErrors || !canSave,
    onClick: onTestConnector != null ? testConnector : undefined
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionConnectorAdd.saveAndTestButtonLabel",
    defaultMessage: "Save & test"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "success",
    "data-test-subj": "create-connector-flyout-save-btn",
    type: "submit",
    isLoading: isSaving,
    disabled: hasErrors || !canSave,
    onClick: onSubmit
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionConnectorAdd.saveButtonLabel",
    defaultMessage: "Save"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null))))) : /*#__PURE__*/_react.default.createElement(_action_type_menu.ActionTypeMenu, {
    featureId: featureId,
    onActionTypeChange: setActionType,
    setHasActionsUpgradeableByTrial: setHasActionsUpgradeableByTrial,
    setAllActionTypes: setAllActionTypes,
    actionTypeRegistry: actionTypeRegistry
  })), /*#__PURE__*/_react.default.createElement(_footer.FlyoutFooter, {
    hasConnectorTypeSelected: hasConnectorTypeSelected,
    onBack: resetActionType,
    onCancel: onClose
  }));
};
const CreateConnectorFlyout = /*#__PURE__*/(0, _react.memo)(CreateConnectorFlyoutComponent);

// eslint-disable-next-line import/no-default-export
exports.default = exports.CreateConnectorFlyout = CreateConnectorFlyout;