"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorFormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _section_loading = require("../../components/section_loading");
var _capabilities = require("../../lib/capabilities");
var _kibana = require("../../../common/lib/kibana");
var _connector_form_fields_global = require("./connector_form_fields_global");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorFormFieldsComponent = ({
  actionTypeModel,
  isEdit,
  registerPreSubmitValidator
}) => {
  var _actionTypeModel$acti;
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const canSave = (0, _capabilities.hasSaveActionsCapability)(capabilities);
  const FieldsComponent = (_actionTypeModel$acti = actionTypeModel === null || actionTypeModel === void 0 ? void 0 : actionTypeModel.actionConnectorFields) !== null && _actionTypeModel$acti !== void 0 ? _actionTypeModel$acti : null;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_connector_form_fields_global.ConnectorFormFieldsGlobal, {
    canSave: canSave
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), FieldsComponent !== null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": "connector-settings-label"
  }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.actionConnectorForm.connectorSettingsLabel",
    defaultMessage: "Connector settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_section_loading.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.triggersActionsUI.sections.actionConnectorForm.loadingConnectorSettingsDescription",
      defaultMessage: "Loading connector settings\u2026"
    }))
  }, /*#__PURE__*/_react.default.createElement(FieldsComponent, {
    readOnly: !canSave,
    isEdit: isEdit,
    registerPreSubmitValidator: registerPreSubmitValidator
  })))) : null);
};
const ConnectorFormFields = /*#__PURE__*/(0, _react.memo)(ConnectorFormFieldsComponent);
exports.ConnectorFormFields = ConnectorFormFields;