"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RulesSettingsLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _rules_settings_modal = require("./rules_settings_modal");
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesSettingsLink = () => {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    show,
    readFlappingSettingsUI
  } = capabilities.rulesSettings;
  if (!show || !readFlappingSettingsUI) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => setIsVisible(true),
    iconType: "gear",
    "data-test-subj": "rulesSettingsLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.rulesSettings.link.title",
    defaultMessage: "Settings"
  })), /*#__PURE__*/_react.default.createElement(_rules_settings_modal.RulesSettingsModal, {
    isVisible: isVisible,
    onClose: () => setIsVisible(false)
  }));
};

// eslint-disable-next-line import/no-default-export
exports.default = exports.RulesSettingsLink = RulesSettingsLink;