"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoPermissionPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoPermissionPrompt = () => /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
  "data-test-subj": "noPermissionPrompt",
  iconType: "securityApp",
  title: /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.noPermissionToCreateTitle",
    defaultMessage: "No permissions to create rules"
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "permissionDeniedMessage"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.triggersActionsUI.sections.rulesList.noPermissionToCreateDescription",
    defaultMessage: "Contact your system administrator."
  }))
});
exports.NoPermissionPrompt = NoPermissionPrompt;