"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransformList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _action_reauthorize = require("../action_reauthorize");
var _common = require("../../../../common");
var _authorization = require("../../../../lib/authorization");
var _create_transform_button = require("../create_transform_button");
var _refresh_transform_list_button = require("../refresh_transform_list_button");
var _action_delete = require("../action_delete");
var _action_reset = require("../action_reset");
var _action_start = require("../action_start");
var _action_schedule_now = require("../action_schedule_now");
var _action_stop = require("../action_stop");
var _use_columns = require("./use_columns");
var _expanded_row = require("./expanded_row");
var _transform_search_bar_filters = require("./transform_search_bar_filters");
var _use_table_settings = require("./use_table_settings");
var _transform_alerting_flyout = require("../../../../../alerting/transform_alerting_flyout");
var _stop_action_modal = require("../action_stop/stop_action_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getItemIdToExpandedRowMap(itemIds, transforms, onAlertEdit) {
  return itemIds.reduce((m, transformId) => {
    const item = transforms.find(transform => transform.config.id === transformId);
    if (item !== undefined) {
      m[transformId] = /*#__PURE__*/_react.default.createElement(_expanded_row.ExpandedRow, {
        item: item,
        onAlertEdit: onAlertEdit
      });
    }
    return m;
  }, {});
}
const TransformList = ({
  onCreateTransform,
  transformNodes,
  transforms,
  transformsLoading
}) => {
  var _query$query$ast$clau, _query$query, _query$query$ast;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    refresh
  } = (0, _common.useRefreshTransformList)({
    isLoading: setIsLoading
  });
  const {
    setEditAlertRule
  } = (0, _transform_alerting_flyout.useAlertRuleFlyout)();
  const [query, setQuery] = (0, _react.useState)();
  const [expandedRowItemIds, setExpandedRowItemIds] = (0, _react.useState)([]);
  const [transformSelection, setTransformSelection] = (0, _react.useState)([]);
  const [isActionsMenuOpen, setIsActionsMenuOpen] = (0, _react.useState)(false);
  const bulkStartAction = (0, _action_start.useStartAction)(false, transformNodes);
  const bulkDeleteAction = (0, _action_delete.useDeleteAction)(false);
  const bulkReauthorizeAction = (0, _action_reauthorize.useReauthorizeAction)(false, transformNodes);
  const bulkResetAction = (0, _action_reset.useResetAction)(false);
  const bulkStopAction = (0, _action_stop.useStopAction)(false);
  const bulkScheduleNowAction = (0, _action_schedule_now.useScheduleNowAction)(false, transformNodes);
  const {
    capabilities
  } = (0, _react.useContext)(_authorization.AuthorizationContext);
  const disabled = !capabilities.canCreateTransform || !capabilities.canPreviewTransform || !capabilities.canStartStopTransform;
  const {
    sorting,
    pagination,
    onTableChange
  } = (0, _use_table_settings.useTableSettings)(_common.TRANSFORM_LIST_COLUMN.ID, transforms);
  const {
    columns,
    modals: singleActionModals
  } = (0, _use_columns.useColumns)(expandedRowItemIds, setExpandedRowItemIds, transformNodes, transformSelection);
  const searchError = query !== null && query !== void 0 && query.error ? query === null || query === void 0 ? void 0 : query.error.message : undefined;
  const clauses = (_query$query$ast$clau = query === null || query === void 0 ? void 0 : (_query$query = query.query) === null || _query$query === void 0 ? void 0 : (_query$query$ast = _query$query.ast) === null || _query$query$ast === void 0 ? void 0 : _query$query$ast.clauses) !== null && _query$query$ast$clau !== void 0 ? _query$query$ast$clau : [];
  const filteredTransforms = clauses.length > 0 ? (0, _transform_search_bar_filters.filterTransforms)(transforms, clauses) : transforms;
  if (transforms.length === 0 && transformNodes === 0) {
    return null;
  }
  if (transforms.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
      verticalPosition: "center",
      horizontalPosition: "center",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.transform.list.emptyPromptTitle', {
        defaultMessage: 'No transforms found'
      })),
      actions: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        fill: true,
        onClick: onCreateTransform,
        isDisabled: disabled,
        "data-test-subj": "transformCreateFirstButton"
      }, _i18n.i18n.translate('xpack.transform.list.emptyPromptButtonText', {
        defaultMessage: 'Create your first transform'
      }))],
      "data-test-subj": "transformNoTransformsFound"
    }))));
  }
  const itemIdToExpandedRowMap = getItemIdToExpandedRowMap(expandedRowItemIds, transforms, setEditAlertRule);
  const bulkActionMenuItems = [/*#__PURE__*/_react.default.createElement("div", {
    key: "startAction",
    className: "transform__BulkActionItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => bulkStartAction.openModal(transformSelection),
    disabled: (0, _action_start.isStartActionDisabled)(transformSelection, capabilities.canStartStopTransform, transformNodes)
  }, /*#__PURE__*/_react.default.createElement(_action_start.StartActionName, {
    items: transformSelection,
    transformNodes: transformNodes
  }))), /*#__PURE__*/_react.default.createElement("div", {
    key: "scheduleNowAction",
    className: "transform__BulkActionItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => bulkScheduleNowAction.scheduleNowTransforms(transformSelection.map(i => ({
      id: i.id
    }))),
    disabled: (0, _action_schedule_now.isScheduleNowActionDisabled)(transformSelection, capabilities.canScheduleNowTransform, transformNodes)
  }, /*#__PURE__*/_react.default.createElement(_action_schedule_now.ScheduleNowActionName, {
    items: transformSelection,
    transformNodes: transformNodes
  }))), /*#__PURE__*/_react.default.createElement("div", {
    key: "stopAction",
    className: "transform__BulkActionItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      bulkStopAction.openModal(transformSelection);
    },
    disabled: (0, _action_stop.isStopActionDisabled)(transformSelection, capabilities.canStartStopTransform, false)
  }, /*#__PURE__*/_react.default.createElement(_action_stop.StopActionName, {
    items: transformSelection
  }))), /*#__PURE__*/_react.default.createElement("div", {
    key: "reauthorizeAction",
    className: "transform__BulkActionItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      bulkReauthorizeAction.openModal(transformSelection);
    },
    disabled: (0, _action_reauthorize.isReauthorizeActionDisabled)(transformSelection, capabilities.canStartStopTransform, transformNodes)
  }, /*#__PURE__*/_react.default.createElement(_action_reauthorize.ReauthorizeActionName, {
    items: transformSelection,
    transformNodes: transformNodes
  }))), /*#__PURE__*/_react.default.createElement("div", {
    key: "resetAction",
    className: "transform__BulkActionItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      bulkResetAction.openModal(transformSelection);
    },
    disabled: (0, _action_reset.isResetActionDisabled)(transformSelection, false)
  }, /*#__PURE__*/_react.default.createElement(_action_reset.ResetActionName, {
    canResetTransform: capabilities.canResetTransform,
    disabled: (0, _action_reset.isResetActionDisabled)(transformSelection, false),
    isBulkAction: true
  }))), /*#__PURE__*/_react.default.createElement("div", {
    key: "deleteAction",
    className: "transform__BulkActionItem"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => bulkDeleteAction.openModal(transformSelection),
    disabled: (0, _action_delete.isDeleteActionDisabled)(transformSelection, false)
  }, /*#__PURE__*/_react.default.createElement(_action_delete.DeleteActionName, {
    canDeleteTransform: capabilities.canDeleteTransform,
    disabled: (0, _action_delete.isDeleteActionDisabled)(transformSelection, false),
    isBulkAction: true
  })))];
  const renderToolsLeft = () => {
    const buttonIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      iconType: "gear",
      color: "text",
      onClick: () => {
        setIsActionsMenuOpen(true);
      },
      "aria-label": _i18n.i18n.translate('xpack.transform.multiTransformActionsMenu.managementActionsAriaLabel', {
        defaultMessage: 'Management actions'
      })
    });
    const bulkActionIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      key: "bulkActionIcon",
      id: "transformBulkActionsMenu",
      button: buttonIcon,
      isOpen: isActionsMenuOpen,
      closePopover: () => setIsActionsMenuOpen(false),
      panelPaddingSize: "s",
      anchorPosition: "rightUp"
    }, bulkActionMenuItems);
    return [/*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      key: "selectedText",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.transform.multiTransformActionsMenu.transformsCount', {
      defaultMessage: '{count} {count, plural, one {transform} other {transforms}} selected',
      values: {
        count: transformSelection.length
      }
    }))), /*#__PURE__*/_react.default.createElement("div", {
      key: "bulkActionsBorder",
      className: "transform__BulkActionsBorder"
    }), bulkActionIcon];
  };
  const toolsRight = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceAround"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_refresh_transform_list_button.RefreshTransformListButton, {
    onClick: refresh,
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_create_transform_button.CreateTransformButton, {
    onClick: onCreateTransform,
    transformNodes: transformNodes
  })));
  const search = {
    toolsLeft: transformSelection.length > 0 ? renderToolsLeft() : undefined,
    toolsRight,
    onChange: setQuery,
    box: {
      incremental: true
    },
    filters: _transform_search_bar_filters.transformFilters
  };
  const selection = {
    onSelectionChange: selected => setTransformSelection(selected)
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformListTableContainer"
  }, bulkStartAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_action_start.StartActionModal, bulkStartAction), bulkDeleteAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_action_delete.DeleteActionModal, bulkDeleteAction), bulkReauthorizeAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_action_reauthorize.ReauthorizeActionModal, bulkReauthorizeAction), bulkResetAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_action_reset.ResetActionModal, bulkResetAction), bulkStopAction.isModalVisible && /*#__PURE__*/_react.default.createElement(_stop_action_modal.StopActionModal, bulkStopAction), singleActionModals, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    allowNeutralSort: false,
    className: "transform__TransformTable",
    columns: columns,
    error: searchError,
    hasActions: false,
    isExpandable: true,
    isSelectable: false,
    items: filteredTransforms,
    itemId: _common.TRANSFORM_LIST_COLUMN.ID,
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    loading: isLoading || transformsLoading,
    onTableChange: onTableChange,
    pagination: pagination,
    rowProps: item => ({
      'data-test-subj': `transformListRow row-${item.id}`
    }),
    selection: selection,
    sorting: sorting,
    search: search,
    "data-test-subj": `transformListTable ${isLoading || transformsLoading ? 'loading' : 'loaded'}`
  }));
};
exports.TransformList = TransformList;