"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stopActionNameText = exports.isStopActionDisabled = exports.StopActionName = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _authorization = require("../../../../lib/authorization");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const stopActionNameText = _i18n.i18n.translate('xpack.transform.transformList.stopActionNameText', {
  defaultMessage: 'Stop'
});
exports.stopActionNameText = stopActionNameText;
const isStopActionDisabled = (items, canStartStopTransform, forceDisable) => {
  // Disable stop action if one of the transforms is stopped already
  const stoppedTransform = items.some(i => i.stats.state === _constants.TRANSFORM_STATE.STOPPED);
  return forceDisable === true || !canStartStopTransform || stoppedTransform === true;
};
exports.isStopActionDisabled = isStopActionDisabled;
const StopActionName = ({
  items,
  forceDisable
}) => {
  const isBulkAction = items.length > 1;
  const {
    canStartStopTransform
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;

  // Disable stop action if one of the transforms is stopped already
  const stoppedTransform = items.some(i => i.stats.state === _constants.TRANSFORM_STATE.STOPPED);
  let stoppedTransformMessage;
  if (isBulkAction === true) {
    stoppedTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.stoppedTransformBulkToolTip', {
      defaultMessage: 'One or more transforms are already stopped.'
    });
  } else {
    stoppedTransformMessage = _i18n.i18n.translate('xpack.transform.transformList.stoppedTransformToolTip', {
      defaultMessage: '{transformId} is already stopped.',
      values: {
        transformId: items[0] && items[0].config.id
      }
    });
  }
  if (!canStartStopTransform || stoppedTransform) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: !canStartStopTransform ? (0, _authorization.createCapabilityFailureMessage)('canStartStopTransform') : stoppedTransformMessage
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, stopActionNameText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, stopActionNameText);
};
exports.StopActionName = StopActionName;