"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _authorization = require("../../../../lib/authorization");
var _delete_action_name = require("./delete_action_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDeleteAction = forceDisable => {
  const {
    canDeleteTransform
  } = (0, _react.useContext)(_authorization.AuthorizationContext).capabilities;
  const deleteTransforms = (0, _hooks.useDeleteTransforms)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [items, setItems] = (0, _react.useState)([]);
  const isBulkAction = items.length > 1;
  const shouldForceDelete = (0, _react.useMemo)(() => items.some(i => i.stats.state === _constants.TRANSFORM_STATE.FAILED), [items]);
  const closeModal = () => setModalVisible(false);
  const {
    userCanDeleteIndex,
    userCanDeleteDataView,
    deleteDestIndex,
    dataViewExists,
    deleteDataView,
    toggleDeleteIndex,
    toggleDeleteDataView
  } = (0, _hooks.useDeleteIndexAndTargetIndex)(items);
  const deleteAndCloseModal = () => {
    setModalVisible(false);
    const shouldDeleteDestIndex = userCanDeleteIndex && deleteDestIndex;
    const shouldDeleteDestDataView = userCanDeleteIndex && userCanDeleteDataView && dataViewExists && deleteDataView;
    // if we are deleting multiple transforms, then force delete all if at least one item has failed
    // else, force delete only when the item user picks has failed
    const forceDelete = isBulkAction ? shouldForceDelete : items[0] && items[0] && items[0].stats.state === _constants.TRANSFORM_STATE.FAILED;
    deleteTransforms({
      transformsInfo: items.map(i => ({
        id: i.config.id,
        state: i.stats.state
      })),
      deleteDestIndex: shouldDeleteDestIndex,
      deleteDestDataView: shouldDeleteDestDataView,
      forceDelete
    });
  };
  const openModal = newItems => {
    if (Array.isArray(newItems)) {
      setItems(newItems);
      setModalVisible(true);
    }
  };
  const action = (0, _react.useMemo)(() => ({
    name: item => /*#__PURE__*/_react.default.createElement(_delete_action_name.DeleteActionName, {
      canDeleteTransform,
      disabled: (0, _delete_action_name.isDeleteActionDisabled)([item], forceDisable),
      isBulkAction: false
    }),
    enabled: item => !(0, _delete_action_name.isDeleteActionDisabled)([item], forceDisable) && canDeleteTransform,
    description: _delete_action_name.deleteActionNameText,
    icon: 'trash',
    type: 'icon',
    onClick: item => openModal([item]),
    'data-test-subj': 'transformActionDelete'
  }), [canDeleteTransform, forceDisable]);
  return {
    action,
    closeModal,
    deleteAndCloseModal,
    deleteDestIndex,
    deleteDataView,
    dataViewExists,
    isModalVisible,
    items,
    openModal,
    shouldForceDelete,
    toggleDeleteIndex,
    toggleDeleteDataView,
    userCanDeleteIndex,
    userCanDeleteDataView
  };
};
exports.useDeleteAction = useDeleteAction;