"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopMetricsAggForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _pivot_configuration = require("../../../../pivot_configuration/pivot_configuration");
var _pivot_aggs = require("../../../../../../../common/pivot_aggs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TopMetricsAggForm = ({
  onChange,
  aggConfig
}) => {
  var _aggConfig$sortSettin, _sortSettings$order;
  const {
    state: {
      fields
    }
  } = (0, _react.useContext)(_pivot_configuration.PivotConfigurationContext);
  const sortFieldOptions = fields.filter(v => _pivot_aggs.TOP_METRICS_SORT_FIELD_TYPES.includes(v.type)).map(({
    name
  }) => ({
    text: name,
    value: name
  }));
  Object.values(_pivot_aggs.TOP_METRICS_SPECIAL_SORT_FIELDS).forEach(v => {
    sortFieldOptions.unshift({
      text: v,
      value: v
    });
  });
  sortFieldOptions.unshift({
    text: '',
    value: ''
  });
  const isSpecialFieldSelected = (0, _pivot_aggs.isSpecialSortField)(aggConfig.sortField);
  const sortDirectionOptions = Object.values(_pivot_aggs.SORT_DIRECTION).map(v => ({
    id: v,
    label: v
  }));
  const sortSettings = (_aggConfig$sortSettin = aggConfig.sortSettings) !== null && _aggConfig$sortSettin !== void 0 ? _aggConfig$sortSettin : {};
  const updateSortSettings = (0, _react.useCallback)(update => {
    var _aggConfig$sortSettin2;
    onChange({
      ...aggConfig,
      sortSettings: {
        ...((_aggConfig$sortSettin2 = aggConfig.sortSettings) !== null && _aggConfig$sortSettin2 !== void 0 ? _aggConfig$sortSettin2 : {}),
        ...update
      }
    });
  }, [aggConfig, onChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.agg.popoverForm.sortFieldTopMetricsLabel",
      defaultMessage: "Sort field"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: sortFieldOptions,
    value: aggConfig.sortField,
    onChange: e => {
      onChange({
        ...aggConfig,
        sortField: e.target.value
      });
    },
    "data-test-subj": "transformSortFieldTopMetricsLabel"
  })), aggConfig.sortField ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isSpecialFieldSelected ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.transform.agg.popoverForm.sortDirectionTopMetricsLabel",
      defaultMessage: "Sort direction"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    type: "single",
    legend: _i18n.i18n.translate('xpack.transform.agg.popoverForm.sortDirectionTopMetricsLabel', {
      defaultMessage: 'Sort direction'
    }),
    options: sortDirectionOptions,
    idSelected: (_sortSettings$order = sortSettings.order) !== null && _sortSettings$order !== void 0 ? _sortSettings$order : '',
    onChange: id => {
      updateSortSettings({
        order: id
      });
    },
    color: "text"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }))) : null);
};
exports.TopMetricsAggForm = TopMetricsAggForm;