"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedRuntimeMappingsEditor = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _mlRuntimeFieldUtils = require("@kbn/ml-runtime-field-utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdvancedRuntimeMappingsEditor = /*#__PURE__*/(0, _react.memo)(({
  actions: {
    convertToJson,
    setAdvancedRuntimeMappingsConfig,
    setRuntimeMappingsEditorApplyButtonEnabled
  },
  state: {
    advancedEditorRuntimeMappingsLastApplied,
    advancedRuntimeMappingsConfig,
    xJsonMode
  }
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "transformAdvancedRuntimeMappingsEditor"
  }, /*#__PURE__*/_react.default.createElement(_public.CodeEditor, {
    height: 250,
    languageId: 'json',
    onChange: d => {
      setAdvancedRuntimeMappingsConfig(d);

      // Disable the "Apply"-Button if the config hasn't changed.
      if (advancedEditorRuntimeMappingsLastApplied === d) {
        setRuntimeMappingsEditorApplyButtonEnabled(false);
        return;
      }

      // Try to parse the string passed on from the editor.
      // If parsing fails, the "Apply"-Button will be disabled
      try {
        // if the user deletes the json in the editor
        // they should still be able to apply changes
        const isEmptyStr = d === '';
        const parsedJson = isEmptyStr ? {} : JSON.parse(convertToJson(d));
        setRuntimeMappingsEditorApplyButtonEnabled(isEmptyStr || (0, _mlRuntimeFieldUtils.isRuntimeMappings)(parsedJson));
      } catch (e) {
        setRuntimeMappingsEditorApplyButtonEnabled(false);
      }
    },
    options: {
      ariaLabel: _i18n.i18n.translate('xpack.transform.stepDefineForm.advancedEditorAriaLabel', {
        defaultMessage: 'Advanced pivot editor'
      }),
      automaticLayout: true,
      fontSize: 12,
      scrollBeyondLastLine: false,
      quickSuggestions: true,
      minimap: {
        enabled: false
      },
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    value: advancedRuntimeMappingsConfig
  }));
}, (prevProps, nextProps) => (0, _lodash.isEqual)(pickProps(prevProps), pickProps(nextProps)));
exports.AdvancedRuntimeMappingsEditor = AdvancedRuntimeMappingsEditor;
function pickProps(props) {
  return [props.state.advancedEditorRuntimeMappingsLastApplied, props.state.advancedRuntimeMappingsConfig];
}