"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResetTransforms = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _type_guards = require("../../../common/api_schemas/type_guards");
var _errors = require("../../../common/utils/errors");
var _app_dependencies = require("../app_dependencies");
var _common = require("../common");
var _components = require("../components");
var _use_api = require("./use_api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useResetTransforms = () => {
  const {
    overlays,
    theme
  } = (0, _app_dependencies.useAppDependencies)();
  const toastNotifications = (0, _app_dependencies.useToastNotifications)();
  const api = (0, _use_api.useApi)();
  return async reqBody => {
    const results = await api.resetTransforms(reqBody);
    if (!(0, _type_guards.isResetTransformsResponseSchema)(results)) {
      toastNotifications.addDanger({
        title: _i18n.i18n.translate('xpack.transform.transformList.resetTransformGenericErrorMessage', {
          defaultMessage: 'An error occurred calling the API endpoint to reset transforms.'
        }),
        text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
          previewTextLength: 50,
          overlays: overlays,
          theme: theme,
          text: (0, _errors.getErrorMessage)(results)
        }), {
          theme$: theme.theme$
        })
      });
      return;
    }
    const isBulk = Object.keys(results).length > 1;
    const successCount = {
      transformReset: 0
    };
    for (const transformId in results) {
      // hasOwnProperty check to ensure only properties on object itself, and not its prototypes
      if (results.hasOwnProperty(transformId)) {
        var _status$transformRese2;
        const status = results[transformId];

        // if we are only resetting one transform, show the success toast messages
        if (!isBulk && status.transformReset) {
          var _status$transformRese;
          if ((_status$transformRese = status.transformReset) !== null && _status$transformRese !== void 0 && _status$transformRese.success) {
            toastNotifications.addSuccess(_i18n.i18n.translate('xpack.transform.transformList.resetTransformSuccessMessage', {
              defaultMessage: 'Request to reset transform {transformId} acknowledged.',
              values: {
                transformId
              }
            }));
          }
        } else {
          Object.keys(successCount).forEach(key => {
            var _status$key;
            if ((_status$key = status[key]) !== null && _status$key !== void 0 && _status$key.success) {
              successCount[key] = successCount[key] + 1;
            }
          });
        }
        if ((_status$transformRese2 = status.transformReset) !== null && _status$transformRese2 !== void 0 && _status$transformRese2.error) {
          const error = status.transformReset.error.reason;
          toastNotifications.addDanger({
            title: _i18n.i18n.translate('xpack.transform.transformList.resetTransformErrorMessage', {
              defaultMessage: 'An error occurred resetting the transform {transformId}',
              values: {
                transformId
              }
            }),
            text: (0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_components.ToastNotificationText, {
              previewTextLength: 50,
              overlays: overlays,
              theme: theme,
              text: error
            }), {
              theme$: theme.theme$
            })
          });
        }
      }
    }

    // if we are deleting multiple transforms, combine the success messages
    if (isBulk) {
      if (successCount.transformReset > 0) {
        toastNotifications.addSuccess(_i18n.i18n.translate('xpack.transform.transformList.bulkResetTransformSuccessMessage', {
          defaultMessage: 'Successfully reset {count} {count, plural, one {transform} other {transforms}}.',
          values: {
            count: successCount.transformReset
          }
        }));
      }
    }
    _common.refreshTransformList$.next(_common.REFRESH_TRANSFORM_LIST_STATE.REFRESH);
  };
};
exports.useResetTransforms = useResetTransforms;