"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useApi = void 0;
var _react = require("react");
var _mlAggUtils = require("@kbn/ml-agg-utils");
var _constants = require("../../../common/constants");
var _app_dependencies = require("../app_dependencies");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useApi = () => {
  const {
    http
  } = (0, _app_dependencies.useAppDependencies)();
  return (0, _react.useMemo)(() => ({
    async getTransformNodes() {
      try {
        return await http.get((0, _constants.addInternalBasePath)(`transforms/_nodes`), {
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async getTransform(transformId) {
      try {
        return await http.get((0, _constants.addInternalBasePath)(`transforms/${transformId}`), {
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async getTransforms(fetchOptions = {}) {
      try {
        return await http.get((0, _constants.addInternalBasePath)(`transforms`), {
          ...fetchOptions,
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async getTransformStats(transformId) {
      try {
        return await http.get((0, _constants.addInternalBasePath)(`transforms/${transformId}/_stats`), {
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async getTransformsStats(fetchOptions = {}) {
      try {
        return await http.get((0, _constants.addInternalBasePath)(`transforms/_stats`), {
          ...fetchOptions,
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async createTransform(transformId, transformConfig) {
      try {
        return await http.put((0, _constants.addInternalBasePath)(`transforms/${transformId}`), {
          body: JSON.stringify(transformConfig),
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async updateTransform(transformId, transformConfig) {
      try {
        return await http.post((0, _constants.addInternalBasePath)(`transforms/${transformId}/_update`), {
          body: JSON.stringify(transformConfig),
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async deleteTransforms(reqBody) {
      try {
        return await http.post((0, _constants.addInternalBasePath)(`delete_transforms`), {
          body: JSON.stringify(reqBody),
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async getTransformsPreview(obj) {
      try {
        return await http.post((0, _constants.addInternalBasePath)(`transforms/_preview`), {
          body: JSON.stringify(obj),
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async reauthorizeTransforms(reqBody) {
      try {
        return await http.post((0, _constants.addInternalBasePath)(`reauthorize_transforms`), {
          body: JSON.stringify(reqBody),
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async resetTransforms(reqBody) {
      try {
        return await http.post((0, _constants.addInternalBasePath)(`reset_transforms`), {
          body: JSON.stringify(reqBody),
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async startTransforms(reqBody) {
      try {
        return await http.post((0, _constants.addInternalBasePath)(`start_transforms`), {
          body: JSON.stringify(reqBody),
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async stopTransforms(transformsInfo) {
      try {
        return await http.post((0, _constants.addInternalBasePath)(`stop_transforms`), {
          body: JSON.stringify(transformsInfo),
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async scheduleNowTransforms(transformsInfo) {
      try {
        return await http.post((0, _constants.addInternalBasePath)(`schedule_now_transforms`), {
          body: JSON.stringify(transformsInfo),
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async getTransformAuditMessages(transformId, sortField, sortDirection) {
      try {
        return await http.get((0, _constants.addInternalBasePath)(`transforms/${transformId}/messages`), {
          query: {
            sortField,
            sortDirection
          },
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async getEsIndices() {
      try {
        return await http.get(`/api/index_management/indices`, {
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async getEsIngestPipelines() {
      try {
        return await http.get('/api/ingest_pipelines', {
          version: '1'
        });
      } catch (e) {
        return e;
      }
    },
    async getHistogramsForFields(dataViewTitle, fields, query, runtimeMappings, samplerShardSize = _mlAggUtils.DEFAULT_SAMPLER_SHARD_SIZE) {
      try {
        return await http.post((0, _constants.addInternalBasePath)(`field_histograms/${dataViewTitle}`), {
          body: JSON.stringify({
            query,
            fields,
            samplerShardSize,
            ...(runtimeMappings !== undefined ? {
              runtimeMappings
            } : {})
          }),
          version: '1'
        });
      } catch (e) {
        return e;
      }
    }
  }), [http]);
};
exports.useApi = useApi;