"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../common/constants");
var _components = require("./components");
var _constants2 = require("./common/constants");
var _authorization = require("./lib/authorization");
var _clone_transform = require("./sections/clone_transform");
var _create_transform = require("./sections/create_transform");
var _transform_management = require("./sections/transform_management");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const App = ({
  history
}) => {
  const {
    apiError
  } = (0, _react.useContext)(_authorization.AuthorizationContext);
  if (apiError !== null) {
    return /*#__PURE__*/_react.default.createElement(_components.SectionError, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.transform.app.checkingPrivilegesErrorMessage",
        defaultMessage: "Error fetching user privileges from the server"
      }),
      error: apiError
    });
  }
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/${_constants2.SECTION_SLUG.CLONE_TRANSFORM}/:transformId`,
    component: _clone_transform.CloneTransformSection
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/${_constants2.SECTION_SLUG.CREATE_TRANSFORM}/:savedObjectId`,
    component: _create_transform.CreateTransformSection
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `/`,
    component: _transform_management.TransformManagementSection
  })));
};
exports.App = App;
const renderApp = (element, appDependencies) => {
  const I18nContext = appDependencies.i18n.Context;
  (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: appDependencies.theme.theme$
  }, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: appDependencies
  }, /*#__PURE__*/_react.default.createElement(_authorization.AuthorizationProvider, {
    privilegesEndpoint: {
      path: (0, _constants.addInternalBasePath)(`privileges`),
      version: '1'
    }
  }, /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(App, {
    history: appDependencies.history
  })))))), element);
  return () => {
    (0, _reactDom.unmountComponentAtNode)(element);
  };
};
exports.renderApp = renderApp;