"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InvestigateInTimelineContextMenu = exports.InvestigateInTimelineButtonIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_investigate_in_timeline = require("../hooks/use_investigate_in_timeline");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Investigate in timeline button, uses the InvestigateInTimelineAction component (x-pack/plugins/security_solution/public/detections/components/alerts_table/timeline_actions/investigate_in_timeline_action.tsx)
 * retrieved from the SecuritySolutionContext.
 *
 * This component renders an {@link EuiContextMenu}.
 *
 * @returns investigate in timeline for a context menu
 */
const InvestigateInTimelineContextMenu = ({
  data,
  onClick,
  'data-test-subj': dataTestSub
}) => {
  const {
    investigateInTimelineFn
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)({
    indicator: data
  });
  if (!investigateInTimelineFn) {
    return null;
  }
  const menuItemClicked = () => {
    if (onClick) onClick();
    investigateInTimelineFn();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "investigateInTime",
    onClick: () => menuItemClicked(),
    "data-test-subj": dataTestSub
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "Investigate in Timeline",
    id: "xpack.threatIntelligence.investigateInTimelineButton"
  }));
};

/**
 * Investigate in timeline button uses the InvestigateInTimelineAction component (x-pack/plugins/security_solution/public/detections/components/alerts_table/timeline_actions/investigate_in_timeline_action.tsx)
 * retrieved from the SecuritySolutionContext.
 *
 * This component renders an {@link EuiButtonIcon}.
 *
 * @returns add to timeline button icon
 */
exports.InvestigateInTimelineContextMenu = InvestigateInTimelineContextMenu;
const InvestigateInTimelineButtonIcon = ({
  data,
  'data-test-subj': dataTestSub
}) => {
  const {
    investigateInTimelineFn
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)({
    indicator: data
  });
  if (!investigateInTimelineFn) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.BUTTON_ICON_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _translations.BUTTON_ICON_LABEL,
    iconType: "timeline",
    iconSize: "s",
    size: "xs",
    color: "primary",
    onClick: investigateInTimelineFn,
    "data-test-subj": dataTestSub
  }));
};
exports.InvestigateInTimelineButtonIcon = InvestigateInTimelineButtonIcon;