"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.translateFieldLabel = exports.IndicatorFieldLabel = void 0;
var _react = _interopRequireDefault(require("react"));
var _indicator = require("../../../../../common/types/indicator");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Renders field label using i18n, or the field key if the translation is not available
 */
const IndicatorFieldLabel = ({
  field
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, translateFieldLabel(field));

/** This translates the field name using kbn-i18n */
exports.IndicatorFieldLabel = IndicatorFieldLabel;
const translateFieldLabel = field => {
  // This switch is necessary as i18n id cannot be dynamic, see:
  // https://github.com/elastic/kibana/blob/main/src/dev/i18n/README.md
  switch (field) {
    case _indicator.RawIndicatorFieldId.TimeStamp:
      {
        return _translations.TIMESTAMP;
      }
    case _indicator.RawIndicatorFieldId.Name:
      {
        return _translations.INDICATORS;
      }
    case _indicator.RawIndicatorFieldId.Type:
      {
        return _translations.TYPE;
      }
    case _indicator.RawIndicatorFieldId.Feed:
      {
        return _translations.FEED;
      }
    case _indicator.RawIndicatorFieldId.FirstSeen:
      {
        return _translations.FIRST_SEEN;
      }
    case _indicator.RawIndicatorFieldId.LastSeen:
      {
        return _translations.LAST_SEEN;
      }
    case _indicator.RawIndicatorFieldId.Confidence:
      {
        return _translations.CONFIDENCE;
      }
    case _indicator.RawIndicatorFieldId.MarkingTLP:
      {
        return _translations.TLP_MARKETING;
      }
    default:
      return field;
  }
};
exports.translateFieldLabel = translateFieldLabel;