"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorsBarChartWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _indicator = require("../../../../../common/types/indicator");
var _field_selector = require("./field_selector");
var _barchart = require("./barchart");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_FIELD = _indicator.RawIndicatorFieldId.Feed;
/**
 * Displays the {@link IndicatorsBarChart} and {@link IndicatorsFieldSelector} components,
 * and handles retrieving aggregated indicator data.
 */
const IndicatorsBarChartWrapper = /*#__PURE__*/(0, _react.memo)(({
  timeRange,
  indexPattern,
  isLoading,
  isFetching,
  series,
  dateRange,
  field,
  onFieldChange
}) => {
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      hasShadow: false,
      hasBorder: false,
      paddingSize: "xl"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": _test_ids.LOADING_TEST_ID,
      size: "xl"
    }))));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'spaceBetween'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: 's'
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.threatIntelligence.indicator.barchartSection.title",
    defaultMessage: "Trend"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_field_selector.IndicatorsFieldSelector, {
    indexPattern: indexPattern,
    defaultStackByValue: DEFAULT_FIELD,
    valueChange: onFieldChange
  }))), isFetching && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": _test_ids.CHART_UPDATE_PROGRESS_TEST_ID,
    size: "xs",
    color: "accent",
    position: "absolute"
  }), timeRange && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.BARCHART_WRAPPER_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_barchart.IndicatorsBarChart, {
    indicators: series,
    dateRange: dateRange,
    field: field
  })));
});
exports.IndicatorsBarChartWrapper = IndicatorsBarChartWrapper;