"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.untilPluginStartServicesReady = exports.setKibanaServices = exports.core = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let core;
exports.core = core;
const servicesReady$ = new _rxjs.BehaviorSubject(undefined);
const untilPluginStartServicesReady = () => {
  if (servicesReady$.value) return Promise.resolve(servicesReady$.value);
  return new Promise(resolve => {
    const subscription = servicesReady$.subscribe(deps => {
      if (deps) {
        subscription.unsubscribe();
        resolve(deps);
      }
    });
  });
};
exports.untilPluginStartServicesReady = untilPluginStartServicesReady;
const setKibanaServices = kibanaCore => {
  exports.core = core = kibanaCore;
  core.theme.theme$.subscribe(({
    darkMode
  }) => {
    servicesReady$.next({
      core,
      darkMode
    });
  });
};
exports.setKibanaServices = setKibanaServices;